################################################################################
#
# iperf3_openbfc
#
################################################################################

IPERF3_OPENBFC_VERSION = 3.15
IPERF3_OPENBFC_SITE = $(OPENBFC_PACKAGE_APPS_DIR)/iperf3_openbfc
IPERF3_OPENBFC_SITE_METHOD = local
IPERF3_OPENBFC_REDISTRIBUTE = YES
IPERF3_OPENBFC_DEPENDENCIES = linux openssl
IPERF3_OPENBFC_INSTALL_STAGING = YES
IPERF3_OPENBFC_LICENSE = BSD-3-Clause, BSD-2-Clause, MIT
IPERF3_OPENBFC_LICENSE_FILES = LICENSE

# Extract
# ------------------------------------------------------------------------------
IPERF3_OPENBFC_POST_RSYNC_HOOKS += BASE_PKG_CUSTOM_EXTRACT

# Patch
# ------------------------------------------------------------------------------
IPERF3_OPENBFC_POST_RSYNC_HOOKS += BASE_PKG_CUSTOM_PATCH

# Configure
# ------------------------------------------------------------------------------
define IPERF3_OPENBFC_CONFIGURE_CMDS
	$(call base-pkg-configure, "OPENSSLDIR=$(STAGING_DIR)/usr")
endef

# Build
# ------------------------------------------------------------------------------
define IPERF3_OPENBFC_BUILD_CMDS
	$(call base-pkg-build)
endef

# Stage
# ------------------------------------------------------------------------------
define IPERF3_OPENBFC_INSTALL_STAGING_CMDS
	$(call base-pkg-stage)
endef

# Install
# ------------------------------------------------------------------------------
define IPERF3_OPENBFC_INSTALL_TARGET_CMDS
	$(call base-pkg-release-install,$(TARGET_DIR))
endef

$(eval $(generic-package))
