# $1 is the images directory. This is automatically passed in by BR.
# The following are explicitly passed in via the BR config
#    option BR2_ROOTFS_POST_SCRIPT_ARGS
# $2 is the Linux version.
# $3 is the config BR2_PACKAGE_OPENBFC_CHIP_FAMILY

#!/bin/sh

set -u
set -e

prg=`basename $0`

if [ ! -e ${TARGET_DIR}/bin/sh ]; then
	echo "Symlinking /bin/bash -> /bin/sh..."
	ln -s bash ${TARGET_DIR}/bin/sh
fi

if ! grep /bin/sh ${TARGET_DIR}/etc/shells >/dev/null; then
	echo "Adding /bin/sh to /etc/shells..."
	echo "/bin/sh" >>${TARGET_DIR}/etc/shells
fi

# Auto-login on serial console
if [ -e ${TARGET_DIR}/etc/inittab ]; then
	echo "Enabling auto-login on serial console..."
	sed -i 's|.* # GENERIC_SERIAL$|::respawn:/bin/cttyhack /bin/sh -l|' \
		${TARGET_DIR}/etc/inittab
fi

if ls board/brcmstb/dropbear_*_host_key >/dev/null 2>&1; then
	echo "Installing pre-generated SSH keys..."
	rm -rf ${TARGET_DIR}/etc/dropbear
	mkdir -p ${TARGET_DIR}/etc/dropbear
	for key in board/brcmstb/dropbear_*_host_key; do
		b=`basename "${key}"`
		echo "    ${b}"
		install -D -p -m 0600 -t ${TARGET_DIR}/etc/dropbear ${key}
	done
fi

# Enabling dropbear (rcS file inherited from the classic rootfs for now)
rcS="${TARGET_DIR}/etc/init.d/rcS"
if grep 'if [ -e /sbin/dropbear ]' "$rcS" >/dev/null; then
	echo "Enabling dropbear rcS..."
	sed -i 's| -e /sbin/dropbear | -e /usr/sbin/dropbear |' ${rcS}
fi

# Add SSH key for root
sshdir="${TARGET_DIR}/root/.ssh"
if [ -r board/brcmstb/brcmstb_root ]; then
	echo "Installing SSH key for root..."
	rm -rf "${sshdir}"
	mkdir "${sshdir}"
	chmod go= "${sshdir}"
	cp board/brcmstb/brcmstb_root.pub "${sshdir}/authorized_keys"
fi

# Create mount points
echo "Creating mount points..."
rm -r ${TARGET_DIR}/mnt
mkdir ${TARGET_DIR}/mnt
if [ "$3" = "3390" ]; then
	MOUNT_POINTS="hd nfs usb flash cmnonvol cmnonvol_bak"
else
	MOUNT_POINTS="hd nfs usb ata bp3lic bp3lic_bak"
fi
for d in $MOUNT_POINTS; do
	mkdir ${TARGET_DIR}/mnt/${d}
done

# Generate brcmstb.conf
echo "Generating /etc/brcmstb.conf..."
arch=`basename ${BASE_DIR}`
# The Linux directory can be "linux-custom" or "linux-$tag". We also must ensure
# we don't pick up directories like "linux-tools" or "linux-firmware".
linux_dir=`ls -drt ${BUILD_DIR}/linux-* | egrep 'linux-(stb|custom)' | head -1`
linux_ver=`./bin/linuxver.sh $linux_dir`
cat >${TARGET_DIR}/etc/brcmstb.conf <<EOF
TFTPHOST=`hostname -f`
TFTPPATH=$linux_ver
PLAT=$3
VERSION=$linux_ver
EOF

# Generate list of GPL-3.0 packages
echo "Generating GPL-3.0 packages list"
make -C ${BASE_DIR} legal-info
rm -rf ${TARGET_DIR}/usr/share/legal-info/
mkdir ${TARGET_DIR}/usr/share/legal-info/
grep "GPL-3.0" ${BASE_DIR}/legal-info/manifest.csv  | cut -d, -f1 > ${TARGET_DIR}/usr/share/legal-info/GPL-3.0-packages
sed -i 's| -e /bin/gdbserver -o -e /bin/gdb | -s /usr/share/legal-info/GPL-3.0-packages |' ${rcS}

# Create symbol link for lattice
if [ ! -e ${TARGET_DIR}/bin/udpsvd ]; then
	echo "Symlinking /bin/busybox -> /bin/udpsvd..."
	ln -sfT busybox ${TARGET_DIR}/bin/udpsvd
fi

if [ ! -e ${TARGET_DIR}/sbin/tftpd ]; then
	echo "Symlinking /bin/busybox -> /sbin/tftpd..."
	ln -sfT ../bin/busybox ${TARGET_DIR}/sbin/tftpd
fi

if [ ! -e ${TARGET_DIR}/sbin/udhcpd ]; then
	echo "Symlinking /bin/busybox -> /sbin/udhcpd..."
	ln -sfT ../bin/busybox ${TARGET_DIR}/sbin/udhcpd
fi

if [ -e ${TARGET_DIR}/usr/sbin/odhcp6c-update ] && [ ! -e ${TARGET_DIR}/usr/local/etc/odhcp6c_script.sh ]; then
	echo "Symlinking /usr/sbin/odhcp6c-update -> /usr/local/etc/odhcp6c_script.sh..."
	ln -sfT ../../sbin/odhcp6c-update ${TARGET_DIR}/usr/local/etc/odhcp6c_script.sh
	ln -sfT ../../sbin/odhcp6c-list-helper.bash ${TARGET_DIR}/usr/local/etc/odhcp6c-list-helper.bash
fi

set +u
if [ -z $FOXCONN_INITRD_IMAGE ]; then
	echo "Normal build"
else
	echo "Reduce initrd kernel size"
	rm -rf ${TARGET_DIR}/bin/hcs32
	rm -rf ${TARGET_DIR}/bin/macsec
	rm -rf ${TARGET_DIR}/bin/bolt*
	rm -rf ${TARGET_DIR}/bin/diag*
	rm -rf ${TARGET_DIR}/bin/dm*
	rm -rf ${TARGET_DIR}/bin/top
	rm -rf ${TARGET_DIR}/bin/factmode
	rm -rf ${TARGET_DIR}/bin/mso_feat
	rm -rf ${TARGET_DIR}/bin/nv_sync
	rm -rf ${TARGET_DIR}/bin/fxLAG*
	rm -rf ${TARGET_DIR}/bin/ipc*
	rm -rf ${TARGET_DIR}/bin/fxlogfile
	rm -rf ${TARGET_DIR}/bin/bootassist
	rm -rf ${TARGET_DIR}/bin/snmp*
	rm -rf ${TARGET_DIR}/bin/lsblk
	rm -rf ${TARGET_DIR}/bin/lsattr
	rm -rf ${TARGET_DIR}/bin/progstore
	rm -rf ${TARGET_DIR}/bin/rprogramstore
	rm -rf ${TARGET_DIR}/bin/snmp_mibs_brcmd
	rm -rf ${TARGET_DIR}/bin/vmstat
	rm -rf ${TARGET_DIR}/bin/voicefailoverd
	rm -rf ${TARGET_DIR}/bin/lattice*
	rm -rf ${TARGET_DIR}/bin/wdmd
	rm -rf ${TARGET_DIR}/sbin/ip
	rm -rf ${TARGET_DIR}/sbin/tc
	rm -rf ${TARGET_DIR}/sbin/e2fsck
	rm -rf ${TARGET_DIR}/sbin/devlink
	rm -rf ${TARGET_DIR}/sbin/ss
	rm -rf ${TARGET_DIR}/sbin/iptraf-ng
	rm -rf ${TARGET_DIR}/sbin/rdma
	rm -rf ${TARGET_DIR}/sbin/bridge
	rm -rf ${TARGET_DIR}/sbin/tipc
	rm -rf ${TARGET_DIR}/sbin/udpcp*
	rm -rf ${TARGET_DIR}/sbin/hdparm
	rm -rf ${TARGET_DIR}/sbin/mke2fs
	rm -rf ${TARGET_DIR}/sbin/dcb
	rm -rf ${TARGET_DIR}/sbin/tune2fs
	rm -rf ${TARGET_DIR}/lib/modules
	rm -rf ${TARGET_DIR}/lib/firmware
	rm -rf ${TARGET_DIR}/lib/liblattice*
	rm -rf ${TARGET_DIR}/lib/libdma*
	rm -rf ${TARGET_DIR}/lib/libitc_rpc*
	rm -rf ${TARGET_DIR}/lib/ebtables
	rm -rf ${TARGET_DIR}/lib/libn*
	rm -rf ${TARGET_DIR}/lib/libwd*
	rm -rf ${TARGET_DIR}/lib/libbcm*
	rm -rf ${TARGET_DIR}/lib/libfdt*
	rm -rf ${TARGET_DIR}/lib/libpthread*
	rm -rf ${TARGET_DIR}/lib/libcustotp*
	rm -rf ${TARGET_DIR}/lib/libdiagman*
	rm -rf ${TARGET_DIR}/lib/librt*
	rm -rf ${TARGET_DIR}/lib/libmount*
	rm -rf ${TARGET_DIR}/lib/libmacsec*
	rm -rf ${TARGET_DIR}/lib/libblkid*
	rm -rf ${TARGET_DIR}/lib/libhcs*
	rm -rf ${TARGET_DIR}/tmp/*
	rm -rf ${TARGET_DIR}/usr/bin/*
	rm -rf ${TARGET_DIR}/usr/sbin/*
	rm -rf ${TARGET_DIR}/usr/local/*
	rm -rf ${TARGET_DIR}/usr/share/screen
	rm -rf ${TARGET_DIR}/usr/share/snmp
	rm -rf ${TARGET_DIR}/usr/share/xtables
	rm -rf ${TARGET_DIR}/usr/share/udhcpc
	rm -rf ${TARGET_DIR}/usr/share/zoneinfo/
	rm -rf ${TARGET_DIR}/usr/share/pci*
	rm -rf ${TARGET_DIR}/usr/libexec/*
	rm -rf ${TARGET_DIR}/usr/lib/tc
	rm -rf ${TARGET_DIR}/usr/lib/php
	rm -rf ${TARGET_DIR}/usr/lib/conntrack-tools
	rm -rf ${TARGET_DIR}/usr/lib/terminfo
	rm -rf ${TARGET_DIR}/usr/lib/lighttpd
	rm -rf ${TARGET_DIR}/usr/lib/xtables
	rm -rf ${TARGET_DIR}/usr/lib/libnetsnmp*
	rm -rf ${TARGET_DIR}/usr/lib/libnetfilter*
	rm -rf ${TARGET_DIR}/usr/lib/libext2fs*
	rm -rf ${TARGET_DIR}/usr/lib/liblzma*
	rm -rf ${TARGET_DIR}/usr/lib/libip*
	rm -rf ${TARGET_DIR}/usr/lib/libdw*
	rm -rf ${TARGET_DIR}/usr/lib/elfutils*
	rm -rf ${TARGET_DIR}/usr/lib/libelf*
	rm -rf ${TARGET_DIR}/usr/lib/libssl*
	rm -rf ${TARGET_DIR}/usr/lib/libsyn123*
	rm -rf ${TARGET_DIR}/usr/lib/libpcre*
	rm -rf ${TARGET_DIR}/usr/lib/libz.so*
	rm -rf ${TARGET_DIR}/usr/lib/libkmod*
	rm -rf ${TARGET_DIR}/usr/lib/libprocps*
	rm -rf ${TARGET_DIR}/usr/lib/libform*
	rm -rf ${TARGET_DIR}/usr/lib/libxtables*
	rm -rf ${TARGET_DIR}/usr/lib/libout*
	rm -rf ${TARGET_DIR}/usr/lib/libpopt*
	rm -rf ${TARGET_DIR}/usr/lib/libpci*
	rm -rf ${TARGET_DIR}/usr/lib/libpcrecpp*
	rm -rf ${TARGET_DIR}/usr/lib/libe2p*
	rm -rf ${TARGET_DIR}/usr/lib/libasm*
	rm -rf ${TARGET_DIR}/usr/lib/libmenu*
	rm -rf ${TARGET_DIR}/usr/lib/libnfnetlink*
	rm -rf ${TARGET_DIR}/usr/lib/libss*
	rm -rf ${TARGET_DIR}/usr/lib/libmnl*
	rm -rf ${TARGET_DIR}/usr/lib/libcrypto*
fi
