################################################################################
#
# wl
#
################################################################################

WL_VERSION = 1.0
WL_SITE = $(BRCM_WIFI_PACKAGE_CUSTOM_DIR)/wl
WL_SITE_METHOD = local
WL_REDISTRIBUTE = YES

WL_DEPENDENCIES = linux $(if $(BR2_PACKAGE_RUNNER),runner) openssl libnl

# PRE RSYNC
# ------------------------------------------------------------------------------
define WL_SETUP_SRC_SOFT_LINKS
	rm -rf "$(WL_SITE)/src"; mkdir -p "$(WL_SITE)/src";
	cd "$(WL_SITE)/src" && ln -sf ../Makefile . && ln -sf ../makefiles .

	@if [[ ! -d "$(WL_SITE)/bin" ]]; then \
		cd "$(WL_SITE)/src" && \
		ln -snf ../../../../../../../wl/cmwifi . && \
		ln -snf ../../../../../../../wl/main . && \
		ln -snf ../../../../../../../wl/sys .; \
	fi;
endef

WL_PRE_RSYNC_HOOKS += WL_SETUP_SRC_SOFT_LINKS

# Patch
# ------------------------------------------------------------------------------

# Configure
# ------------------------------------------------------------------------------
define WL_CONFIGURE_CMDS
        $(call base-pkg-configure)
endef

# Build
# ------------------------------------------------------------------------------
define WL_BUILD_CMDS
	$(call base-pkg-build)
endef

# Stage
# ------------------------------------------------------------------------------

# Release / Install
# ------------------------------------------------------------------------------
define WL_INSTALL_TARGET_CMDS
	$(call base-pkg-release-install,$(TARGET_DIR))
endef

$(eval $(generic-package))
