# Recommended makefile usage: Packages
# ------------------------------------------------------------------------------
include $(COMMON_MAKEFILES_DIR)/make.env

VERSION ?= $($(TARGET_UPPERCASE)_VERSION)

TARBALL = $(wildcard *$(VERSION)*.tar.gz)
TARBALL +=$(wildcard *$(VERSION)*.tar.bz2)
TARBALL_FILENAME = $(TARBALL)

PATCH_FILENAMES ?= $(wildcard *$(VERSION)*.patch)

PATCH_DIR ?= $(wildcard *$(VERSION)-patch)
SYSROOT_DIR ?= $(STAGING_DIR)

# Configure options
# ------------------------------------------------------------------------------
CMAKE_DEF_CONFIG_OPTS += \
	-DCMAKE_SYSTEM_NAME=Linux -DCMAKE_SYSTEM_PROCESSOR=$(ARCH) \
	-DCMAKE_C_COMPILER=$(CC) -DCMAKE_CXX_COMPILER=$(CXX) \
	-DCMAKE_FIND_ROOT_PATH=$(SYSROOT_DIR) \
	-DCMAKE_FIND_ROOT_PATH_MODE_PROGRAM=NEVER \
	-DCMAKE_FIND_ROOT_PATH_MODE_INCLUDE=ONLY \
	-DCMAKE_FIND_ROOT_PATH_MODE_LIBRARY=ONLY \
	-DCMAKE_FIND_ROOT_PATH_MODE_PACKAGE=ONLY \
	-DCMAKE_BUILD_TYPE="Release"

# default to Buildroot's config opts if it is not defined
$(TARGET_UPPERCASE)_CONFIG_OPTS ?= $($(TARGET_UPPERCASE)_CONF_OPTS)
$(TARGET_UPPERCASE)_PATCH_P_LEVEL ?= 1

# Commands
# ------------------------------------------------------------------------------
.PHONY: all clean distclean

all_: untar_ patch_ config_ build_ install_

untar_:$(TARGET)_untar_
$(TARGET)_untar_:
	@echo "Untar $(TARGET)."
	$(Q)if [ ! -d $(DIR) ]; then \
		if [ -f ./$(TARBALL_FILENAME) ]; then \
			mkdir -p $(DIR); \
			$(TAR) -xvf $(TARBALL_FILENAME) \
				-C $(DIR) --strip-components=1; \
		else \
			echo "Extract $(TARGET), \"$(TARBALL_FILENAME)\" tarball for version $(VERSION) does not exist."; exit 2; \
		fi \
	else \
		echo "Extract $(TARGET), nothing to do."; \
	fi

patch_:$(TARGET)_patch_
$(TARGET)_patch_:untar_
	@echo "Patch $(TARGET)."
	$(Q)if [ -d $(DIR) ] && [ ! -f $(DIR)/.stamp_patched ]; then \
		for pfile in $(PATCH_FILENAMES); do  \
			echo "Patch $$pfile, -p $${${TARGET_UPPERCASE}_PATCH_P_LEVEL}"; \
			patch -d $(DIR) -p$${${TARGET_UPPERCASE}_PATCH_P_LEVEL} < $$pfile; \
		done; \
		if [ $(PATCH_DIR) ]; then \
			echo "Patch $(TARGET)."; \
			cp -a $(wildcard *-$(VERSION)-patch)/* $(DIR)/; \
		fi; \
		touch $(DIR)/.stamp_patched; \
	else \
		echo "Patch $(TARGET), nothing to do."; \
	fi

config_:$(TARGET)_config_
$(TARGET)_config_:patch_
	@echo "Configure $(TARGET)."
	$(Q)if [ ! -d $(DIR)/CMakeFiles ]; then \
		echo "Config $(TARGET). - cmake $(CMAKE_DEF_CONFIG_OPTS) $${$(TARGET_UPPERCASE)_CONFIG_OPTS}"; \
		cd $(DIR); cmake $(CMAKE_DEF_CONFIG_OPTS) $${$(TARGET_UPPERCASE)_CONFIG_OPTS} . ; \
	else \
		echo "Config $(TARGET), nothing to do."; \
	fi

build_:$(TARGET)_
$(TARGET)_:config_
	@echo "Build $(TARGET)."
	$(TARGET_MAKE_ENV) $(MAKE) -C $(DIR) all

release_:
	@echo "Release $(TARGET)."
	$(TARGET_MAKE_ENV) $(MAKE) -C $(DIR) DESTDIR=$(RELEASE_DIR)/install_dir install

# stage from release directory
stage_:
	@echo "Staging $(TARGET)."
	if [ ! -d $(RELEASE_DIR)/install_dir ]; then \
		echo "Warning - Release for $(TARGET) - $(RELEASE_DIR)/install_dir is not found."; \
		exit 1; \
	fi;
	@for file in $(RELEASE_DIR)/install_dir/*; do  \
		cp -rp $$file $(STAGING_DIR); \
	done;

# install from release directory
install_:
	@echo "Install $(TARGET)."
	if [ ! -d install_dir ]; then \
		echo "Warning - Release for $(TARGET) - install_dir is not found."; \
		exit 1; \
	fi;
	@for file in install_dir/*; do  \
		cp -rp $$file $(INSTALL_DIR); \
	done;

clean_config_:
	@echo "Clean $(TARGET) Configuration."
	- @rm -rf $(DIR)/CMakeFiles
	- @rm -f $(DIR)/CMakeCache.txt

clean_:
	@echo "Clean $(TARGET)."
	- @rm -rf $(DIR)
	- @rm -rf .release_$(ARCH)

distclean_: clean_
	- @rm -rf .release_*
	- @rm -rf *_working_*
