# Recommended makefile usage: Application
# ------------------------------------------------------------------------------
include $(COMMON_MAKEFILES_DIR)/make.env

# Extra flags
# ------------------------------------------------------------------------------
$(TARGET)_OFLAG   ?= -O
$(TARGET)_CFLAGS  += $($(TARGET)_OFLAG) -I. -I$(BUILD_DIR)/../public/include \
			-I$(BUILD_DIR)/../../public/include \
			-I$(STAGING_DIR)/usr/include \
			$(EXTERNAL_CFLAGS)
$(TARGET)_CPPFLAGS+= $($(TARGET)_OFLAG) -I. -I$(BUILD_DIR)/../public/include \
			-I$(BUILD_DIR)/../../public/include \
			-I$(STAGING_DIR)/usr/include \
			$(EXTERNAL_CPPFLAGS)
$(TARGET)_LDFLAGS += -L. -L$(STAGING_DIR)/usr/lib \
			$(EXTERNAL_LDFLAGS)
$(TARGET)_LDLIBS  += $(EXTERNAL_LDLIBS)

STAGE_CMD=$(foreach subdir, $(PUBLIC_DIRS), stage-rule/$(subdir))

# Sources
# ------------------------------------------------------------------------------
SRC 	?= $(wildcard *.c)
SRC_CC 	?= $(wildcard *.cc)
SRC_CPP ?= $(wildcard *.cpp)

# Objects
# ------------------------------------------------------------------------------
OBJS_C	:= $(patsubst %, %_c_$(ARCH).o, $(basename $(SRC)))
OBJS_CC	:= $(patsubst %, %_cc_$(ARCH).o, $(basename $(SRC_CC)))
OBJS_CPP:= $(patsubst %, %_cpp_$(ARCH).o, $(basename $(SRC_CPP)))

# Dependence
# ------------------------------------------------------------------------------
DEP_C	:= $(patsubst %, %.d, $(basename $(OBJS_C)))
DEP_CC  := $(patsubst %, %.d, $(basename $(OBJS_CC)))
DEP_CPP := $(patsubst %, %.d, $(basename $(OBJS_CPP)))

# Commands
# ------------------------------------------------------------------------------
.PHONY: all clean distclean

all_: clean_ untar_ patch_ config_ build_ dep_ stage_ release_ install_

untar_:
	@echo "Extract $(TARGET), nothing to do."

patch_:
	@echo "Patch $(TARGET), nothing to do."

config_:
	@echo "Config $(TARGET), nothing to do."

%_c_$(ARCH).o: %.c
	@echo "Build $@"
	$(CC) 	$(CFLAGS) $($(TARGET)_CFLAGS) -o $@ -c $<

%_cc_$(ARCH).o: %.cc
	@echo "Build $@"
	$(CC)	$(CFLAGS) $($(TARGET)_CFLAGS) -o $@ -c $<

%_cpp_$(ARCH).o: %.cpp
	@echo "Build $@"
	$(CXX) 	$(CPPFLAGS) $($(TARGET)_CPPFLAGS) -o $@ -c $<

build_: $(OBJS_C) $(OBJS_CC) $(OBJS_CPP) dep_
	@echo "Build $(TARGET)."
	$(CXX) 	$(LDFLAGS) $($(TARGET)_LDFLAGS) \
		-o $(TARGET) $(OBJS_C) $(OBJS_CC) $(OBJS_CPP) $($(TARGET)_LDLIBS)

dep_: $(DEP_C) $(DEP_CC) $(DEP_CPP)

stage_: $(STAGE_CMD)

stage-rule/%:
	@echo "Stage $(TARGET) public include directory."
	$(INSTALL) -D -m 0755 $*/*.h $(STAGING_DIR)/usr/include

release_:
	@echo "Release $(TARGET)."
	mkdir -p $(RELEASE_DIR)
	$(INSTALL) -D -m 0644 $(TARGET) $(RELEASE_DIR)

install_:
	@echo "Install $(TARGET)."
	mkdir -p $(INSTALL_DIR)/bin
	$(INSTALL) -D -m 0755 $(TARGET) $(INSTALL_DIR)/bin/$(TARGET_NO_SUFFIX)
	$(STRIP) $(INSTALL_DIR)/bin/$(TARGET_NO_SUFFIX)

clean_:
	@echo "Clean $(TARGET)."
	- @rm -f *.o *.d $(TARGET)
	- @rm -rf $(wildcard .release_$(ARCH)*)


distclean_: clean_
	- @rm -rf .release_*

# Include the rule for making dependency files.
# ------------------------------------------------------------------------------
include $(COMMON_MAKEFILES_DIR)/make.dep
