################################################################################
# Broadcom Buildroot External Base Tree
################################################################################

PKG_RSYNC_LIST_FILE=$(BUILD_DIR)/pkg-rsync-list.txt
PKG_LINUX_HEADERS_INSTALL_STAMP=$(LINUX_DIR)/.stamp_base_pkg_linux_headers_installed

# base makefile(s) shared
# ------------------------------------------------------------------------------
STAGING_SHARE_DIR=$(STAGING_DIR)/usr/share
MAKEFILES_DIR=$(BR2_EXTERNAL_BASE_PATH)/makefiles

$(shell mkdir -p $(STAGING_DIR))
$(shell mkdir -p $(STAGING_DIR)/usr)
$(shell mkdir -p $(STAGING_SHARE_DIR))
$(shell mkdir -p $(STAGING_SHARE_DIR)/build)

$(shell cp $(MAKEFILES_DIR)/make.app 	$(STAGING_SHARE_DIR))
$(shell cp $(MAKEFILES_DIR)/make.config $(STAGING_SHARE_DIR))
$(shell cp $(MAKEFILES_DIR)/make.dep 	$(STAGING_SHARE_DIR))
$(shell cp $(MAKEFILES_DIR)/make.fw	$(STAGING_SHARE_DIR))
$(shell cp $(MAKEFILES_DIR)/make.image  $(STAGING_SHARE_DIR))
$(shell cp $(MAKEFILES_DIR)/make.info 	$(STAGING_SHARE_DIR))
$(shell cp $(MAKEFILES_DIR)/make.lib 	$(STAGING_SHARE_DIR))
$(shell cp $(MAKEFILES_DIR)/make.mod 	$(STAGING_SHARE_DIR))
$(shell cp $(MAKEFILES_DIR)/make.script	$(STAGING_SHARE_DIR))

RELEASE_DIR=$(@D)/$(KERNEL_ARCH)

PRIVATE_SRC=$(@D)/src
TARGET_LIB_FILE=$(@D)/src/lib$(TARGET).so
TARGET_LIB_PREBUILT_FILE=$(RELEASE_DIR)/lib$(TARGET).so

PUBLIC_DIR=$(@D)/public
PUBLIC_INCLUDE_DIR=$(PUBLIC_DIR)/include
PUBLIC_HEADER_FILE=$(PUBLIC_INCLUDE_DIR)/$(TARGET).h
PUBLIC_HEADER_FILES=$(PUBLIC_INCLUDE_DIR)/*.h

PKG_FULL_LOWERCASE=$(shell echo $(PKG) | tr '[:upper:]' '[:lower:]')

TARGET=$(shell echo $(PKG) | tr '[:upper:]' '[:lower:]' | \
	sed -e 's/^openbfc_//' -e 's/_openbfc//' -e 's/_app\b//' -e 's/_fw\b//' -e 's/_lib\b//' -e 's/_mod\b//' -e 's/_script\b//' -e 's/_scripts\b//')
TARGET_UPPERCASE=$(shell echo $(TARGET) | tr '[:lower:]' '[:upper:]')

SRC_EXTRACT_DIR=$(TARGET)_working_$(ARCH)

BASE_MAKE_OPTS= VERSION=$($(PKG)_VERSION) \
		ARCH=$(KERNEL_ARCH) TARGET=$(TARGET) TARGET_UPPERCASE=$(TARGET_UPPERCASE) LINUX_DIR=$(LINUX_DIR) LINUX_HDR_DIR=$(STAGING_DIR)/usr/include \
		DIR=$(SRC_EXTRACT_DIR) TARGET_CROSS=$(TARGET_CROSS) STRIP=$(TARGET_CROSS)strip \
		LINUX_VER_STR="$(shell make -C $(LINUX_DIR)/ -s --no-print-directory kernelrelease)" \
		BRCM_CABLE=y BRCM_CHIP=$(BR2_PACKAGE_OPENBFC_CHIP_FAMILY) \
		$(TARGET)_LOG_LEVEL=$(BR2_PACKAGE_$(PKG)_LOG_LEVEL) \
		$(TARGET)_CFG_FILE=$(BR2_PACKAGE_$(PKG)_CFG_FILE) \
		PUBLIC_INCLUDE_DIR=$(PUBLIC_INCLUDE_DIR) \
		COMMON_MAKEFILES_DIR=$(MAKEFILES_DIR) \
		CONFIG_FILE=$(BUILD_DIR)/../.config_ TAR=$(TAR) TARGET_DIR=$(TARGET_DIR) RELEASE_DIR=$(RELEASE_DIR)

SRC_MAKE_OPTS=	-C $(PRIVATE_SRC) $(BASE_MAKE_OPTS) BUILD_DIR=$(@D)/src TOPDIR=$(TOPDIR)
WL_SRC_MAKE_OPTS=  -C $(PRIVATE_SRC) $(BASE_MAKE_OPTS) BUILD_DIR=$(@D)/src
PREBUILT_OPTS=	-C $(RELEASE_DIR) $(BASE_MAKE_OPTS)
FIRMWARE_OPTS=  -C $(@D)/bin  $(BASE_MAKE_OPTS)
SCRIPT_OPTS  =	-C $(RELEASE_DIR) $(BASE_MAKE_OPTS)

# Hooks
# -----------------------------------------------------------------------------
define BASE_PKG_CUSTOM_EXTRACT
	@if [[ -d $(PRIVATE_SRC) ]]; then \
		$(TARGET_MAKE_ENV) $(MAKE) $(SRC_MAKE_OPTS) untar; \
	fi;
endef

define BASE_PKG_CUSTOM_PATCH
	@if [[ -d $(PRIVATE_SRC) ]]; then \
		$(TARGET_MAKE_ENV) $(MAKE) $(SRC_MAKE_OPTS) patch; \
	fi;
endef

define BASE_PKG_CUSTOM_PREPARE
	$(TARGET_MAKE_ENV) $(MAKE) $(SRC_MAKE_OPTS) prepare
endef


# Functions
# -----------------------------------------------------------------------------
define base-inner-linux-headers-install
	if [[ ! -d $(LINUX_DIR) ]]; then \
		$(TARGET_MAKE_ENV) $(MAKE) -C $(CONFIG_DIR) linux-rebuild; \
	fi;

	# Make sure linux version headers up to date
	(cd $(LINUX_DIR); \
		$(TARGET_MAKE_ENV) $(MAKE) \
			ARCH=$(KERNEL_ARCH) \
			CROSS_COMPILE=$(TARGET_CROSS) \
			HOSTCC="$(HOSTCC)" \
			HOSTCFLAGS="$(HOSTCFLAGS)" \
			HOSTCXX="$(HOSTCXX)" \
			INSTALL_HDR_PATH=$(STAGING_DIR)/usr \
			headers_install)

	(cd $(LINUX_DIR) ; \
		$(TARGET_MAKE_ENV) $(MAKE) \
			ARCH=$(KERNEL_ARCH) \
			CROSS_COMPILE=$(TARGET_CROSS) \
			kernelrelease)

	(cd $(LINUX_DIR) ; \
		$(TARGET_MAKE_ENV) $(MAKE) \
			ARCH=$(KERNEL_ARCH) \
			CROSS_COMPILE=$(TARGET_CROSS) \
			include/config/kernel.release)

	touch $(PKG_LINUX_HEADERS_INSTALL_STAMP)
endef

define base-pkg-linux-headers-install
	$(if $(wildcard $(PKG_LINUX_HEADERS_INSTALL_STAMP)),,$(call base-inner-linux-headers-install))
endef

define base-pkg-configure
	$(call base-pkg-linux-headers-install)
	@if [[ -d $(PRIVATE_SRC) ]]; then \
		$(TARGET_MAKE_ENV) $(TARGET_CONFIGURE_OPTS) $(MAKE) $(SRC_MAKE_OPTS) $(1) config; \
	fi;
endef

define base-pkg-clean-reconfigure
	@if [[ -d $(PRIVATE_SRC) ]]; then \
		$(TARGET_MAKE_ENV) $(TARGET_CONFIGURE_OPTS) $(MAKE) $(SRC_MAKE_OPTS) $(1) clean_config; \
	fi;
endef

define base-inner-pkg-rsync-list-add
	touch $(PKG_RSYNC_LIST_FILE)
	if [ -z $(shell grep -w "$(PKG_FULL_LOWERCASE)" $(PKG_RSYNC_LIST_FILE)) ]; then \
		echo $(PKG_FULL_LOWERCASE) >> $(PKG_RSYNC_LIST_FILE); \
	fi;
endef

#For brcm-wifi package let package specific rule decide how/when to make use
#TARGET_MAKE, TARGET_CONFIGURE OPTS
define base-pkg-build
	$(call base-pkg-linux-headers-install)
	$(call base-inner-pkg-rsync-list-add)
	@if [[ -d $(PRIVATE_SRC) ]]; then \
		echo "Source for $(TARGET) exists, so using it"; \
		if [[ "$(TARGET)" == "wl" ]] ; then \
			BR2_EXT_TARGET_CONFIGURE_OPTS='$(TARGET_CONFIGURE_OPTS)' \
			$(TARGET_MAKE_ENV) $(MAKE) $(WL_SRC_MAKE_OPTS) $(1) build || exit 2; \
		else \
			if [[ ! -f $(@D)/src/$(SRC_EXTRACT_DIR)/configure ]]; then \
				$(MAKE) $(SRC_MAKE_OPTS) $(TARGET_CONFIGURE_OPTS) $(1) build || exit 2; \
			else \
				$(TARGET_MAKE_ENV) $(TARGET_CONFIGURE_OPTS) $(MAKE) $(SRC_MAKE_OPTS) $(1) build || exit 2; \
			fi; \
		fi; \
	else \
		echo "No $(TARGET) source, using prebuilt"; \
	fi;
endef

define base-pkg-release
	$(call base-inner-pkg-rsync-list-add)
	@if [[ -d $(PRIVATE_SRC) ]]; then \
		rm -rf $(RELEASE_DIR) 2>/dev/null; \
		mkdir -p $(RELEASE_DIR); \
		cd $(RELEASE_DIR); ln -sf ../Makefile .;  ln -sf ../makefiles .;\
		$(TARGET_MAKE_ENV) $(MAKE) $(SRC_MAKE_OPTS) RELEASE_DIR=$(RELEASE_DIR) release; \
	fi;
endef

define base-pkg-stage
	$(call base-pkg-release)
	@if [ -d $(PUBLIC_INCLUDE_DIR) ]; then \
		if [ -e $(PUBLIC_HEADER_FILE) ]; then \
			$(INSTALL) -D -m 0644 $(PUBLIC_HEADER_FILE) '$(STAGING_DIR)/usr/include/.'; \
		fi; \
		if [ ! -z $(1) ]; then \
			if [ -z $(2) ]; then \
				$(INSTALL) -D -m 0644 '$(PUBLIC_INCLUDE_DIR)/$(1)' '$(STAGING_DIR)/usr/include/.'; \
			else \
				$(INSTALL) -D -m 0644 '$(PUBLIC_INCLUDE_DIR)/$(1)' '$(STAGING_DIR)/$(2)/.'; \
			fi; \
		fi; \
	fi;
	@if [[ -d $(PRIVATE_SRC) ]]; then \
		if [ -e $(TARGET_LIB_FILE) ]; then \
			$(INSTALL) -D -m 0644 $(TARGET_LIB_FILE) $(STAGING_DIR)/usr/lib/.; \
		fi; \
		if [ -d $(PRIVATE_SRC)/mod ] ; then \
			ln -sfT $(PRIVATE_SRC)/mod $(STAGING_DIR)/usr/share/build/$(TARGET); \
		fi; \
		$(TARGET_MAKE_ENV) $(TARGET_CONFIGURE_OPTS) $(MAKE) $(SRC_MAKE_OPTS) DESTDIR=$(STAGING_DIR) stage || exit 2; \
	else \
		echo "No $(TARGET) source, staging with prebuilt"; \
		if [ -e $(TARGET_LIB_PREBUILT_FILE) ]; then \
			$(INSTALL) -D -m 0644 $(TARGET_LIB_PREBUILT_FILE) $(STAGING_DIR)/usr/lib/.; \
		fi; \
	fi;
endef

define base-pkg-release-install
	$(call base-pkg-release)
	$(TARGET_MAKE_ENV) $(MAKE) $(PREBUILT_OPTS) INSTALL_DIR=$(1) install
endef

define base-pkg-install-firmware
	$(call base-inner-pkg-rsync-list-add)
	$(TARGET_MAKE_ENV) $(MAKE) $(FIRMWARE_OPTS) INSTALL_DIR=$(1) install
endef

define base-pkg-install-image
	$(call base-inner-pkg-rsync-list-add)
	$(TARGET_MAKE_ENV) $(MAKE) $(PREBUILT_OPTS) BINARIES_DIR=$(1) image
endef

define base-pkg-install-script
	$(call base-pkg-release)
	$(TARGET_MAKE_ENV) $(MAKE) $(SCRIPT_OPTS) INSTALL_DIR=$(1) install
endef
