#****************************************************************************
#
# Portions of this software Copyright (c) 2007-2014 Broadcom Corporation
#
#*****************************************************************************
#
#  Filename:       common_brcm.mak
#  Author:         Mike Sieweke
#  Creation Date:  1-Aug-2007
#
#*****************************************************************************
#  Description:
#       This is all the common code from the existing make files.
#
#*****************************************************************************

mkfile_path := $(abspath $(lastword $(MAKEFILE_LIST)))
TOP_DIR = $(basename $(subst rbb_cm_lib/NetSNMP/Source/net-snmp-5.0.9/,,$(dir $(mkfile_path))))

RBB_CM_SRC_DIR = $(TOP_DIR)/rbb_cm_src
RBB_CM_LIB_DIR = $(TOP_DIR)/rbb_cm_lib

LIB_SUPPORT_DIR = $(RBB_CM_SRC_DIR)/Bfc/LibSupport
NETSNMP_INC_DIR = $(LIB_SUPPORT_DIR)/NetSnmp/NetSnmp/include
NETSNMP_LIB_DIR = $(LIB_SUPPORT_DIR)/NetSnmp/NetSnmp


# If we didn't find a BFC dir, see if we're in a V2 dir.
# 
ifeq ($(TOP_DIR),)
  
  # try to find a V2 file and fail if we can't 
  TEST_FILE = CmApp_Docsis1.0/CmAppMain.h

  ifeq ($(TOP_DIR),)
    junk := $(shell echo Error: Top directory not found!>&2)
    could not determine if we are BFC or V2 - STOP
  endif
    
  LIB_SUPPORT_DIR = $(TOP_DIR)/LibSupport
  NETSNMP_INC_DIR = $(LIB_SUPPORT_DIR)/NetSnmp/include
  NETSNMP_LIB_DIR = $(LIB_SUPPORT_DIR)/NetSnmp
    
endif


#####################################################################
# VxWorks build
#####################################################################

ifdef WIND_BASE

TGT_DIR=$(WIND_BASE)/target
include $(TGT_DIR)/h/make/defs.default
include $(TGT_DIR)/h/make/make.RC32364sfgnu
include $(TGT_DIR)/h/make/defs.$(WIND_HOST_TYPE)

EXTRA_INCLUDE  +=
        -I. \
        -IT:/Tornado-wm/target/h

EXTRA_DEFINE   = -DVXWORKS=1

LIB  = $(libname)_vxworks.a

MY_AR = armips

CFLAGS  +=  -DTARGETOS_vxWorks

endif
## end of VxWorks specific stuff ####################################


#####################################################################
# eCos build
#####################################################################

ifdef ECOS_DIR

# jb-gcc5.3 : Overwrite default ECOS_CONFIG directory with local tree
#             The default ECOS_CONFIG_ROOT points to /projects/bfc/ecos20
ECOS_CONFIG_ROOT=${RBB_CM_SRC_DIR}/Bfc/LibSupport/eCos
ECOS_CONFIG_DIR=bcm33xx_ipv6_install
DEFS_FILE =  $(RBB_CM_SRC_DIR)/CableModemBsp/defs.bsp
include $(DEFS_FILE)

CC_OPTIM = -O1

EXTRA_INCLUDE += \
        -I.

LIB  = $(libname)_ecos.a

MY_AR   = $(AR)
CFLAGS +=  -DTARGETOS_eCos -ffunction-sections -O1

endif
## end of eCos specific stuff #######################################


#####################################################################
# QNX
#####################################################################

ifdef QNX_TARGET

DEFS_FILE = $(TOP_DIR)/cm_bsp_v2/bsp_common/os/qnx/makeinc/defs.bsp
include $(DEFS_FILE)

LIB  = $(libname)_Qnx6.a

MY_AR          = ar
EXTRA_INCLUDE += -I.
CFLAGS        += -DTARGETOS_Qnx6

endif
## end of QNX specific stuff #######################################


ifeq ($(libname),libnetsnmp)

  # openSSL 1.0.1 support
  ifeq ($(MAKE_NETSNMP_OPENSSL), 1)
    EXTRA_INCLUDE += -I$(LIB_SUPPORT_DIR)/OpenSSL/include
    LIB  = $(libname)_ecos_openssl.a
    CFLAGS += -DBFC_INCLUDE_OPENSSL
  else
    EXTRA_INCLUDE += -I$(LIB_SUPPORT_DIR)/OpenSSL/include
  endif

endif


####################################################################
# Rules to build objects and libraries...
####################################################################


$(LIB) : $(OBJS)
#	echo objs $(OBJS)
#	echo lib  $(LIB)
	$(MY_AR) cru $(LIB) $?
	- $(RM) $(NETSNMP_LIB_DIR)/$(LIB)
	cp $(LIB) $(NETSNMP_LIB_DIR)/$(LIB)

%.o : %.s
	@ $(RM) $@
	$(CC) $(CFLAGS_AS) -c -o $@ $< 

%.o : %.c 
	@ $(RM) $@
	$(CC) $(CFLAGS) -c -o $@ $<

clean:
	- $(RM) $(LIB)
	- $(RM) $(OBJS)
	- $(RM) $(NETSNMP_LIB_DIR)/$(LIB)
	@echo 
	@echo $(mkfile_path) 
	@echo $(RBB_CM_LIB_DIR)
	@echo $(RBB_CM_SRC_DIR)
	@echo 
copy:
	- $(RM) $(NETSNMP_LIB_DIR)/$(LIB)
	cp $(LIB) $(NETSNMP_LIB_DIR)/$(LIB)

