/*
 * This file was generated by mib2c and is intended for use as
 * a mib module for the ucd-snmp snmpd agent. 
 */


/*
 * This should always be included first before anything else 
 */
#include <net-snmp/net-snmp-config.h>

#include <sys/types.h>
#if HAVE_WINSOCK_H
#include <winsock.h>
#endif
#if HAVE_STDLIB_H
#include <stdlib.h>
#endif
#if HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif


/*
 * minimal include directives 
 */
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>

#include "header_complex.h"
#include "snmpNotifyFilterProfileTable.h"


/*
 * snmpNotifyFilterProfileTable_variables_oid:
 *   this is the top level oid that we want to register under.  This
 *   is essentially a prefix, with the suffix appearing in the
 *   variable below.
 */


oid             snmpNotifyFilterProfileTable_variables_oid[] =
    { 1, 3, 6, 1, 6, 3, 13, 1, 2 };


/*
 * variable2 snmpNotifyFilterProfileTable_variables:
 *   this variable defines function callbacks and type return information 
 *   for the snmpNotifyFilterProfileTable mib section 
 */


struct variable2 snmpNotifyFilterProfileTable_variables[] = {
    /*
     * magic number        , variable type , ro/rw , callback fn  , L, oidsuffix 
     */
#define   SNMPNOTIFYFILTERPROFILENAME  3
    {SNMPNOTIFYFILTERPROFILENAME, ASN_OCTET_STR, RWRITE,
     var_snmpNotifyFilterProfileTable, 2, {1, 1}},
#define   SNMPNOTIFYFILTERPROFILESTORTYPE  4
    {SNMPNOTIFYFILTERPROFILESTORTYPE, ASN_INTEGER, RWRITE,
     var_snmpNotifyFilterProfileTable, 2, {1, 2}},
#define   SNMPNOTIFYFILTERPROFILEROWSTATUS  5
    {SNMPNOTIFYFILTERPROFILEROWSTATUS, ASN_INTEGER, RWRITE,
     var_snmpNotifyFilterProfileTable, 2, {1, 3}},

};
/*
 * (L = length of the oidsuffix) 
 */


/*
 * global storage of our data, saved in and configured by header_complex() 
 */
/* BRCM_MOD remove static so we can use this elsewhere. */
/* static struct header_complex_index *snmpNotifyFilterProfileTableStorage = NULL;  */
struct header_complex_index *snmpNotifyFilterProfileTableStorage = NULL;



// BRCM_MOD PR 7207: externally callable API to register this table if
// need be.
void register_snmpNotifyFilterProfileTable(void)
{
    static int Registered = 0;
    
    // Only do this once.
    if (Registered)
      return;
      
    /*
     * register ourselves with the agent to handle our mib tree 
     */
    
    Registered = 1;

    REGISTER_MIB("snmpNotifyFilterProfileTable",
                 snmpNotifyFilterProfileTable_variables, variable2,
                 snmpNotifyFilterProfileTable_variables_oid);
}


/*
 * init_snmpNotifyFilterProfileTable():
 *   Initialization routine.  This is called when the agent starts up.
 *   At a minimum, registration of your variables should take place here.
 */
void
init_snmpNotifyFilterProfileTable(void)
{
    DEBUGMSGTL(("snmpNotifyFilterProfileTable", "initializing...  "));


    /*
     * register ourselves with the agent to handle our mib tree 
     */
     // BRCM_MOD 5/13/04: don't register this MIB unless explicitly instructed
     // to via register_snmpNotifyFilterProfileTable, above.
//    REGISTER_MIB("snmpNotifyFilterProfileTable",
//                 snmpNotifyFilterProfileTable_variables, variable2,
//                 snmpNotifyFilterProfileTable_variables_oid);


    /*
     * register our config handler(s) to deal with registrations 
     */
    // BRCM_MOD remove config file reads
    //snmpd_register_config_handler("snmpNotifyFilterProfileTable",
    //                              parse_snmpNotifyFilterProfileTable, NULL,
    //                              NULL);

    
    /*
     * we need to be called back later to store our data 
     */
    // BRCM_MOD remove all store callbacks
    //snmp_register_callback(SNMP_CALLBACK_LIBRARY, SNMP_CALLBACK_STORE_DATA,
    //                       store_snmpNotifyFilterProfileTable, NULL);


    /*
     * place any other initialization junk you need here 
     */


    DEBUGMSGTL(("snmpNotifyFilterProfileTable", "done.\n"));
}


/*
 * snmpNotifyFilterProfileTable_add(): adds a structure node to our data set 
 */
int
snmpNotifyFilterProfileTable_add(struct snmpNotifyFilterProfileTable_data
                                 *thedata)
{
    netsnmp_variable_list *vars = NULL;


    DEBUGMSGTL(("snmpNotifyFilterProfileTable", "adding data...  "));
    /*
     * add the index variables to the varbind list, which is 
     * used by header_complex to index the data 
     */

    snmp_varlist_add_variable(&vars, NULL, 0, ASN_PRIV_IMPLIED_OCTET_STR,
                              (u_char *) thedata->snmpTargetParamsName,
                              thedata->snmpTargetParamsNameLen);

    header_complex_add_data(&snmpNotifyFilterProfileTableStorage, vars,
                            thedata);
    DEBUGMSGTL(("snmpNotifyFilterProfileTable", "registered an entry\n"));


    DEBUGMSGTL(("snmpNotifyFilterProfileTable", "done.\n"));
    return SNMPERR_SUCCESS;
}


/*
 * parse_snmpNotifyFilterProfileTable():
 *   parses .conf file entries needed to configure the mib.
 */
#if NOT_FOR_ECOS
void
parse_snmpNotifyFilterProfileTable(const char *token, char *line)
{
    size_t          tmpint;
    struct snmpNotifyFilterProfileTable_data *StorageTmp =
        SNMP_MALLOC_STRUCT(snmpNotifyFilterProfileTable_data);

    DEBUGMSGTL(("snmpNotifyFilterProfileTable", "parsing config...  "));

    if (StorageTmp == NULL) {
        config_perror("malloc failure");
        return;
    }

    line =
        read_config_read_data(ASN_OCTET_STR, line,
                              &StorageTmp->snmpTargetParamsName,
                              &StorageTmp->snmpTargetParamsNameLen);
    if (StorageTmp->snmpTargetParamsName == NULL) {
        config_perror("invalid specification for snmpTargetParamsName");
        return;
    }

    line =
        read_config_read_data(ASN_OCTET_STR, line,
                              &StorageTmp->snmpNotifyFilterProfileName,
                              &StorageTmp->snmpNotifyFilterProfileNameLen);

    line =
        read_config_read_data(ASN_INTEGER, line,
                              &StorageTmp->snmpNotifyFilterProfileStorType,
                              &tmpint);

    line =
        read_config_read_data(ASN_INTEGER, line,
                              &StorageTmp->
                              snmpNotifyFilterProfileRowStatus, &tmpint);

    snmpNotifyFilterProfileTable_add(StorageTmp);

    DEBUGMSGTL(("snmpNotifyFilterProfileTable", "done.\n"));
}
#endif //NOT_FOR_ECOS


/*
 * store_snmpNotifyFilterProfileTable():
 *   stores .conf file entries needed to configure the mib.
 */
#if NOT_FOR_ECOS
int
store_snmpNotifyFilterProfileTable(int majorID, int minorID,
                                   void *serverarg, void *clientarg)
{
    char            line[SNMP_MAXBUF];
    char           *cptr;
    size_t          tmpint;
    struct snmpNotifyFilterProfileTable_data *StorageTmp;
    struct header_complex_index *hcindex;


    DEBUGMSGTL(("snmpNotifyFilterProfileTable", "storing data...  "));

    for (hcindex = snmpNotifyFilterProfileTableStorage; hcindex != NULL;
         hcindex = hcindex->next) {
        StorageTmp =
            (struct snmpNotifyFilterProfileTable_data *) hcindex->data;

        if (StorageTmp->snmpNotifyFilterProfileStorType == ST_NONVOLATILE) {

            memset(line, 0, sizeof(line));
            strcat(line, "snmpNotifyFilterProfileTable ");
            cptr = line + strlen(line);

            cptr =
                read_config_store_data(ASN_OCTET_STR, cptr,
                                       &StorageTmp->snmpTargetParamsName,
                                       &StorageTmp->
                                       snmpTargetParamsNameLen);
            cptr =
                read_config_store_data(ASN_OCTET_STR, cptr,
                                       &StorageTmp->
                                       snmpNotifyFilterProfileName,
                                       &StorageTmp->
                                       snmpNotifyFilterProfileNameLen);
            cptr =
                read_config_store_data(ASN_INTEGER, cptr,
                                       &StorageTmp->
                                       snmpNotifyFilterProfileStorType,
                                       &tmpint);
            cptr =
                read_config_store_data(ASN_INTEGER, cptr,
                                       &StorageTmp->
                                       snmpNotifyFilterProfileRowStatus,
                                       &tmpint);

            snmpd_store_config(line);
        }
    }
    DEBUGMSGTL(("snmpNotifyFilterProfileTable", "done.\n"));
    return 0;
}
#endif  //NOT_FOR_ECOS



/*
 * var_snmpNotifyFilterProfileTable():
 *   Handle this table separately from the scalar value case.
 *   The workings of this are basically the same as for var_snmpNotifyFilterProfileTable above.
 */
unsigned char  *
var_snmpNotifyFilterProfileTable(struct variable *vp,
                                 oid * name,
                                 size_t * length,
                                 int exact,
                                 size_t * var_len,
                                 WriteMethod ** write_method)
{


    struct snmpNotifyFilterProfileTable_data *StorageTmp = NULL;


    DEBUGMSGTL(("snmpNotifyFilterProfileTable",
                "var_snmpNotifyFilterProfileTable: Entering...  \n"));
    /*
     * this assumes you have registered all your data properly
     */
    if ((StorageTmp = (struct snmpNotifyFilterProfileTable_data *)
         header_complex((struct header_complex_index *)
                        snmpNotifyFilterProfileTableStorage, vp, name,
                        length, exact, var_len, write_method)) == NULL) {
        if (vp->magic == SNMPNOTIFYFILTERPROFILEROWSTATUS)
            *write_method = write_snmpNotifyFilterProfileRowStatus;
            
        // BRCM_MOD (KO): in order to handle multiple VBs in the same PDU
        // we must assign write methods here for ALL columns, not just
        // RowStatus.
        else if (vp->magic == SNMPNOTIFYFILTERPROFILENAME)
            *write_method = write_snmpNotifyFilterProfileName;
        else if (vp->magic == SNMPNOTIFYFILTERPROFILESTORTYPE)
            *write_method = write_snmpNotifyFilterProfileStorType;
        
        return NULL;
    }

    /*
     * this is where we do the value assignments for the mib results.
     */
    switch (vp->magic) {

    case SNMPNOTIFYFILTERPROFILENAME:
        *write_method = write_snmpNotifyFilterProfileName;
        *var_len = StorageTmp->snmpNotifyFilterProfileNameLen;
        return (u_char *) StorageTmp->snmpNotifyFilterProfileName;

    case SNMPNOTIFYFILTERPROFILESTORTYPE:
        *write_method = write_snmpNotifyFilterProfileStorType;
        *var_len = sizeof(StorageTmp->snmpNotifyFilterProfileStorType);
        return (u_char *) & StorageTmp->snmpNotifyFilterProfileStorType;

    case SNMPNOTIFYFILTERPROFILEROWSTATUS:
        *write_method = write_snmpNotifyFilterProfileRowStatus;
        *var_len = sizeof(StorageTmp->snmpNotifyFilterProfileRowStatus);
        return (u_char *) & StorageTmp->snmpNotifyFilterProfileRowStatus;


    default:
        ERROR_MSG("");
    }
    return NULL;
}




int
write_snmpNotifyFilterProfileName(int action,
                                  u_char * var_val,
                                  u_char var_val_type,
                                  size_t var_val_len,
                                  u_char * statP,
                                  oid * name, size_t name_len)
{
    static char    *tmpvar;
    struct snmpNotifyFilterProfileTable_data *StorageTmp = NULL;
    static size_t   tmplen;
    size_t          newlen =
        name_len -
        (sizeof(snmpNotifyFilterProfileTable_variables_oid) / sizeof(oid) +
         3 - 1);


    DEBUGMSGTL(("snmpNotifyFilterProfileTable",
                "write_snmpNotifyFilterProfileName entering action=%d...  \n",
                action));
    if ((StorageTmp = (struct snmpNotifyFilterProfileTable_data *)
         header_complex((struct header_complex_index *)
                        snmpNotifyFilterProfileTableStorage, NULL,
                        &name[sizeof
                              (snmpNotifyFilterProfileTable_variables_oid)
                              / sizeof(oid) + 3 - 1], &newlen, 1, NULL,
                        NULL)) == NULL)
    {
        // BRCM_MOD (KO)
        // For the case of multiple VBs in the same PDU, it must be OK for the
        // RESERVE and FREE phases to succeed without the row existing,
        // but the row must be there for the ACTION phase. 
        if ((action != RESERVE1) 
        &&  (action != RESERVE2)
        &&  (action != FREEx))
          return SNMP_ERR_NOTWRITABLE;
        // END BRCM_MOD
    }


    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_OCTET_STR) {
            fprintf(stderr,
                    "write to snmpNotifyFilterProfileName not ASN_OCTET_STR\n");
            return SNMP_ERR_WRONGTYPE;
        }
        break;


    case RESERVE2:
        /*
         * memory reseveration, final preparation... 
         */
         // BRCM_MOD: check length here.
         if ((var_val_len < 1) || (var_val_len > 32))
           return SNMP_ERR_WRONGLENGTH;
           
         // BRCM_MOD: store off length now so row creation w/ createAndGo on
         // a single PDU with RS first, then name will work.  Note that if
         // StorageTmp is NULL, then we don't need to do anything because
         // that means that we haven't gotten around to processing the
         // RS set yet, and if we process the name first then we got no
         // problem anyway.
         if (StorageTmp)
           StorageTmp->snmpNotifyFilterProfileNameLen = var_val_len;
           
        break;


    case FREEx:
        /*
         * Release any resources that have been allocated 
         */
        break;


    case ACTION:
        /*
         * The variable has been stored in string for
         * you to use, and you have just been asked to do something with
         * it.  Note that anything done here must be reversable in the UNDO case 
         */
        tmpvar = StorageTmp->snmpNotifyFilterProfileName;
        tmplen = StorageTmp->snmpNotifyFilterProfileNameLen;
        memdup((u_char **) & StorageTmp->snmpNotifyFilterProfileName,
               var_val, var_val_len);
        StorageTmp->snmpNotifyFilterProfileNameLen = var_val_len;
        
        // BRCM_MOD: transition from notReady to notService
        if (StorageTmp->snmpNotifyFilterProfileRowStatus == RS_NOTREADY)
          StorageTmp->snmpNotifyFilterProfileRowStatus = RS_NOTINSERVICE;
          
        break;


    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        SNMP_FREE(StorageTmp->snmpNotifyFilterProfileName);
        StorageTmp->snmpNotifyFilterProfileName = tmpvar;
        StorageTmp->snmpNotifyFilterProfileNameLen = tmplen;
        
        // BRCM_MOD: undo transition from notReady to notService
        if (StorageTmp->snmpNotifyFilterProfileNameLen == 0)
          StorageTmp->snmpNotifyFilterProfileRowStatus = RS_NOTREADY;
          
        break;


    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail! 
         */
        SNMP_FREE(tmpvar);
        break;
    }
    return SNMP_ERR_NOERROR;
}



int
write_snmpNotifyFilterProfileStorType(int action,
                                      u_char * var_val,
                                      u_char var_val_type,
                                      size_t var_val_len,
                                      u_char * statP,
                                      oid * name, size_t name_len)
{
    static int      tmpvar;
    struct snmpNotifyFilterProfileTable_data *StorageTmp = NULL;
    size_t          newlen =
        name_len -
        (sizeof(snmpNotifyFilterProfileTable_variables_oid) / sizeof(oid) +
         3 - 1);


    DEBUGMSGTL(("snmpNotifyFilterProfileTable",
                "write_snmpNotifyFilterProfileStorType entering action=%d...  \n",
                action));
    if ((StorageTmp = (struct snmpNotifyFilterProfileTable_data *)
         header_complex((struct header_complex_index *)
                        snmpNotifyFilterProfileTableStorage, NULL,
                        &name[sizeof
                              (snmpNotifyFilterProfileTable_variables_oid)
                              / sizeof(oid) + 3 - 1], &newlen, 1, NULL,
                        NULL)) == NULL)
    {
        // BRCM_MOD (KO)
        // For the case of multiple VBs in the same PDU, it must be OK for the
        // RESERVE and FREE phases to succeed without the row existing,
        // but the row must be there for the ACTION phase. 
        if ((action != RESERVE1) 
        &&  (action != RESERVE2)
        &&  (action != FREEx))
          return SNMP_ERR_NOTWRITABLE;
        // END BRCM_MOD
    }


    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            fprintf(stderr,
                    "write to snmpNotifyFilterProfileStorType not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        break;


    case RESERVE2:
        /*
         * memory reseveration, final preparation... 
         */
        // BRCM_MOD: check values.
        if ((*((long *) var_val) != ST_OTHER)
        &&  (*((long *) var_val) != ST_VOLATILE)
        &&  (*((long *) var_val) != ST_NONVOLATILE)
        &&  (*((long *) var_val) != ST_PERMANENT)
        &&  (*((long *) var_val) != ST_READONLY))
          return SNMP_ERR_WRONGVALUE;
          
        // DOCSIS requirement: storageType must only be volatile
        if (*((long *) var_val) != ST_VOLATILE)
          return SNMP_ERR_INCONSISTENTVALUE;
          
        break;


    case FREEx:
        /*
         * Release any resources that have been allocated 
         */
        break;


    case ACTION:
        /*
         * The variable has been stored in long_ret for
         * you to use, and you have just been asked to do something with
         * it.  Note that anything done here must be reversable in the UNDO case 
         */
        tmpvar = StorageTmp->snmpNotifyFilterProfileStorType;
        StorageTmp->snmpNotifyFilterProfileStorType = *((long *) var_val);
        break;


    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        StorageTmp->snmpNotifyFilterProfileStorType = tmpvar;
        break;


    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail! 
         */

        break;
    }
    return SNMP_ERR_NOERROR;
}


int
write_snmpNotifyFilterProfileRowStatus(int action,
                                       u_char * var_val,
                                       u_char var_val_type,
                                       size_t var_val_len,
                                       u_char * statP,
                                       oid * name, size_t name_len)
{
    struct snmpNotifyFilterProfileTable_data *StorageTmp = NULL;
    static struct snmpNotifyFilterProfileTable_data *StorageNew,
        *StorageDel;
    size_t          newlen =
        name_len -
        (sizeof(snmpNotifyFilterProfileTable_variables_oid) / sizeof(oid) +
         3 - 1);
    static int      old_value;
    int             set_value;
    netsnmp_variable_list *vars;
    struct header_complex_index *hciptr;


    StorageTmp = (struct snmpNotifyFilterProfileTable_data *)
        header_complex((struct header_complex_index *)
                       snmpNotifyFilterProfileTableStorage, NULL,
                       &name[sizeof
                             (snmpNotifyFilterProfileTable_variables_oid) /
                             sizeof(oid) + 3 - 1], &newlen, 1, NULL, NULL);




    if (var_val_type != ASN_INTEGER || var_val == NULL) {
        fprintf(stderr,
                "write to snmpNotifyFilterProfileRowStatus not ASN_INTEGER\n");
        return SNMP_ERR_WRONGTYPE;
    }
    set_value = *((long *) var_val);


    /*
     * check legal range, and notReady is reserved for us, not a user 
     */
    // BRCM_MOD: values < 1 or > 6 need WRONGVALUE, not INCONSISTENTVALUE
    // (PR 6218)
    if (set_value < 1 || set_value > 6)
        return SNMP_ERR_WRONGVALUE;
    // BRMC_MOD: Per tComLabs, this should be wrongValue, not inconsistentValue
    else if (set_value == RS_NOTREADY)
        return SNMP_ERR_WRONGVALUE; /* SNMP_ERR_INCONSISTENTVALUE; */


    switch (action) {
    case RESERVE1:
        /*
         * stage one: test validity 
         */
        if (StorageTmp == NULL) {
            /*
             * create the row now? 
             */


            /*
             * ditch illegal values now 
             */
            if (set_value == RS_ACTIVE || set_value == RS_NOTINSERVICE)
                return SNMP_ERR_INCONSISTENTVALUE;

        } else {
            /*
             * row exists.  Check for a valid state change 
             */
            if (set_value == RS_CREATEANDGO
                || set_value == RS_CREATEANDWAIT) {
                /*
                 * can't create a row that exists 
                 */
                return SNMP_ERR_INCONSISTENTVALUE;
            }
            
            // BRCM_MOD: can't go active if we're notReady
            if ((set_value == RS_ACTIVE) && (StorageTmp->snmpNotifyFilterProfileRowStatus == RS_NOTREADY))
                return SNMP_ERR_INCONSISTENTVALUE;
            
            // BRCM_MOD: can't set to notInService if we are noReady
            if ((set_value == RS_NOTINSERVICE) && (StorageTmp->snmpNotifyFilterProfileRowStatus == RS_NOTREADY))
                return SNMP_ERR_INCONSISTENTVALUE;
            
            /*
             * XXX: interaction with row storage type needed 
             */
        }
        break;




    case RESERVE2:
        /*
         * memory reseveration, final preparation... 
         */
        if (StorageTmp == NULL &&
            (set_value == RS_CREATEANDGO
             || set_value == RS_CREATEANDWAIT)) {
            /*
             * creation 
             */
            vars = NULL;

            snmp_varlist_add_variable(&vars, NULL, 0,
                                      ASN_PRIV_IMPLIED_OCTET_STR, NULL, 0);

            if (header_complex_parse_oid
                (&
                 (name
                  [sizeof(snmpNotifyFilterProfileTable_variables_oid) /
                   sizeof(oid) + 2]), newlen, vars) != SNMPERR_SUCCESS) {
                snmp_free_var(vars);
                return SNMP_ERR_INCONSISTENTNAME;
            }

            StorageNew =
                SNMP_MALLOC_STRUCT(snmpNotifyFilterProfileTable_data);
            memdup((u_char **) & (StorageNew->snmpTargetParamsName),
                   vars->val.string, vars->val_len);
            StorageNew->snmpTargetParamsNameLen = vars->val_len;
            
            // BRCM_MOD: make default VOLATILE per DOCSIS requirements
            StorageNew->snmpNotifyFilterProfileStorType = ST_VOLATILE; //ST_NONVOLATILE;

            StorageNew->snmpNotifyFilterProfileRowStatus = set_value;
            snmp_free_var(vars);
            
            // BRCM_MOD (KO): add this row now instead of in ACTION
            snmpNotifyFilterProfileTable_add(StorageNew);
        }


        break;




    case FREEx:
        /*
         * XXX: free, zero vars 
         */
        /*
         * Release any resources that have been allocated 
         */
        break;




    case ACTION:
        /*
         * The variable has been stored in set_value for you to
         * use, and you have just been asked to do something with
         * it.  Note that anything done here must be reversable in
         * the UNDO case 
         */


        if (StorageTmp == NULL &&
            (set_value == RS_CREATEANDGO ||
             set_value == RS_CREATEANDWAIT)) {
            /*
             * row creation, so add it 
             */
            /* BRCM_MOD (KO) - do this in RESERVE2
            if (StorageNew != NULL)
                snmpNotifyFilterProfileTable_add(StorageNew);
            */
            /*
             * XXX: ack, and if it is NULL? 
             */
        } else if (set_value == RS_CREATEANDGO) {
          // BRCM_MOD: don't allow createAndGo row creation w/o a profile name!
          // We must return inconsistentValue and destroy the row.  Do the
          // same thing as in destroy below
          //printf ("createAndGo\n");
          if (StorageTmp->snmpNotifyFilterProfileNameLen == 0)
          {
              //printf ("  not all columns - inconsistentValue!\n");
              return SNMP_ERR_INCONSISTENTVALUE;
          }
        } else if (set_value != RS_DESTROY) {
            /*
             * set the flag? 
             */
            old_value = StorageTmp->snmpNotifyFilterProfileRowStatus;
            StorageTmp->snmpNotifyFilterProfileRowStatus =
                *((long *) var_val);
        } else {
            /*
             * destroy...  extract it for now 
             */
            if (StorageTmp) {
                hciptr =
                    header_complex_find_entry
                    (snmpNotifyFilterProfileTableStorage, StorageTmp);
                StorageDel = (struct snmpNotifyFilterProfileTable_data *)
                    header_complex_extract_entry((struct
                                                  header_complex_index **)
                                                 &snmpNotifyFilterProfileTableStorage,
                                                 hciptr);
            }

        }
        break;




    case UNDO:
        //printf ("UNDO: set_value=%d, StorageTmp=%p, StorageDel=%p, StorageNew=%p\n",
        //        set_value, StorageTmp, StorageDel, StorageNew);
        /*
         * Back out any changes made in the ACTION case 
         */
        if //(StorageTmp == NULL &&
            (set_value == RS_CREATEANDGO ||
             set_value == RS_CREATEANDWAIT) {
            /*
             * row creation, so remove it again 
             */
            hciptr =
                header_complex_find_entry
                (snmpNotifyFilterProfileTableStorage, StorageNew);
            StorageDel = (struct snmpNotifyFilterProfileTable_data *)
                header_complex_extract_entry((struct header_complex_index
                                              **)
                                             &snmpNotifyFilterProfileTableStorage,
                                             hciptr);
            /*
             * XXX: free it 
             */
        } else if (StorageDel != NULL) {
            /*
             * row deletion, so add it again 
             */
            snmpNotifyFilterProfileTable_add(StorageDel);
            StorageDel = NULL;
        } else if (set_value != RS_DESTROY) {
            StorageTmp->snmpNotifyFilterProfileRowStatus = old_value;
        }
        break;




    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail! 
         */
        if (StorageDel != NULL) {
            StorageDel = NULL;
            /*
             * XXX: free it, its dead 
             */
        }
        if (StorageTmp
            && StorageTmp->snmpNotifyFilterProfileRowStatus ==
            RS_CREATEANDGO) {
            StorageTmp->snmpNotifyFilterProfileRowStatus = RS_ACTIVE;
        } else if (StorageTmp &&
                   StorageTmp->snmpNotifyFilterProfileRowStatus ==
                   RS_CREATEANDWAIT) {
            // BRCM_MOD: notReady if we have no profilename
            if (StorageTmp->snmpNotifyFilterProfileNameLen == 0)
              StorageTmp->snmpNotifyFilterProfileRowStatus = RS_NOTREADY;
            else
              StorageTmp->snmpNotifyFilterProfileRowStatus = RS_NOTINSERVICE;
        }
        break;
    }
    return SNMP_ERR_NOERROR;
}



char           *
get_FilterName(char *targetName, size_t targetName_len,
               size_t * profileName_len)
{
    netsnmp_variable_list *vars = NULL;
    struct snmpNotifyFilterProfileTable_data *data;

    /*
     * put requested info into var structure 
     */
    snmp_varlist_add_variable(&vars, NULL, 0, ASN_PRIV_IMPLIED_OCTET_STR,
                              (u_char *) targetName, targetName_len);

    /*
     * get the data from the header_complex storage 
     */
    data = (struct snmpNotifyFilterProfileTable_data *)
        header_complex_get(snmpNotifyFilterProfileTableStorage, vars);

    /*
     * free search index 
     */
    snmp_free_var(vars);

    /*
     * return the requested information (if this row is active) 
     */
    if (data && data->snmpNotifyFilterProfileRowStatus == RS_ACTIVE) {
        *profileName_len = data->snmpNotifyFilterProfileNameLen;
        return data->snmpNotifyFilterProfileName;
    }

    *profileName_len = 0;
    return NULL;
}
