/*
 * Note: this file originally auto-generated by mib2c using
 *        mib2c.brcm.iterate.conf 2003/6/16 turcotte 
 */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>
#include "docsIfUpstreamChannelTable.h"

/** Initialize the docsIfUpstreamChannelTable table by defining its contents and how it's structured */
void
initialize_table_docsIfUpstreamChannelTable(void)
{
    static oid      docsIfUpstreamChannelTable_oid[] =
        { 1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2 };
    netsnmp_handler_registration *my_handler;

    /*
     * create the table structure itself 
     */

    /*
     * if your table is read only, it's easiest to change the
     * HANDLER_CAN_RWRITE definition below to HANDLER_CAN_RONLY 
     */
    my_handler =
        netsnmp_create_handler_registration("docsIfUpstreamChannelTable",
                                            docsIfUpstreamChannelTable_handler,
                                            docsIfUpstreamChannelTable_oid,
                                            OID_LENGTH
                                            (docsIfUpstreamChannelTable_oid),
                                            HANDLER_CAN_RWRITE);

    if (my_handler) {
        if (netsnmp_register_handler(my_handler)) {
            DEBUGMSGTL(("initialize_table_docsIfUpstreamChannelTable",
                        "Handler registration failed!\n"));
            return;
        }
    } else {
        DEBUGMSGTL(("initialize_table_docsIfUpstreamChannelTable",
                    "Handler create failed!\n"));
        return;
    }
    DEBUGMSGTL(("initialize_table_docsIfUpstreamChannelTable",
                "Handler created and registered.\n"));



}

/** Initializes the docsIfUpstreamChannelTable module */
void
init_docsIfUpstreamChannelTable(void)
{

    /*
     * here we initialize all the tables we're planning on supporting 
     */
    initialize_table_docsIfUpstreamChannelTable();
}

/** handles requests for the docsIfUpstreamChannelTable table */
int
docsIfUpstreamChannelTable_handler(netsnmp_mib_handler *handler,
                                   netsnmp_handler_registration *reginfo,
                                   netsnmp_agent_request_info *reqinfo,
                                   netsnmp_request_info *requests)
{

    netsnmp_request_info *request;
    netsnmp_variable_list *var;
    char           *tmpVal[MAX_OID_LEN * sizeof(oid)];
    size_t          tmpValLen;
    int             tmpAsnType, tmpOidLen;
    oid             tmpOid[MAX_OID_LEN];
    int             retVal = SNMP_ERR_NOERROR;

    for (request = requests; request; request = request->next) {
        var = request->requestvb;
        if (request->processed != 0)
            continue;

        /*
         * perform anything here that you need to do before each
         * request is processed. 
         */

        switch (reqinfo->mode) {
        case MODE_GET:
            retVal = v2Get(var->name, var->name_length, tmpVal,
                           &tmpValLen, reqinfo);
            if (retVal == SNMP_ERR_NOERROR) {
                switch (var->name[reginfo->rootoid_len + 1]) {
                case COLUMN_DOCSIFUPCHANNELID:
                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                             (u_char *) tmpVal, tmpValLen);
                    break;

                case COLUMN_DOCSIFUPCHANNELFREQUENCY:
                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                             (u_char *) tmpVal, tmpValLen);
                    break;

                case COLUMN_DOCSIFUPCHANNELWIDTH:
                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                             (u_char *) tmpVal, tmpValLen);
                    break;

                case COLUMN_DOCSIFUPCHANNELMODULATIONPROFILE:
                    snmp_set_var_typed_value(var, ASN_UNSIGNED,
                                             (u_char *) tmpVal, tmpValLen);
                    break;

                case COLUMN_DOCSIFUPCHANNELSLOTSIZE:
                    snmp_set_var_typed_value(var, ASN_UNSIGNED,
                                             (u_char *) tmpVal, tmpValLen);
                    break;

                case COLUMN_DOCSIFUPCHANNELTXTIMINGOFFSET:
                    snmp_set_var_typed_value(var, ASN_UNSIGNED,
                                             (u_char *) tmpVal, tmpValLen);
                    break;

                case COLUMN_DOCSIFUPCHANNELRANGINGBACKOFFSTART:
                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                             (u_char *) tmpVal, tmpValLen);
                    break;

                case COLUMN_DOCSIFUPCHANNELRANGINGBACKOFFEND:
                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                             (u_char *) tmpVal, tmpValLen);
                    break;

                case COLUMN_DOCSIFUPCHANNELTXBACKOFFSTART:
                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                             (u_char *) tmpVal, tmpValLen);
                    break;

                case COLUMN_DOCSIFUPCHANNELTXBACKOFFEND:
                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                             (u_char *) tmpVal, tmpValLen);
                    break;

                default:
                    /*
                     * We shouldn't get here 
                     */
                    snmp_log(LOG_ERR,
                             "problem encountered in docsIfUpstreamChannelTable_handler: unknown column\n");
                }
            } else {
                netsnmp_set_request_error(reqinfo, requests, retVal);
            }
            break;
        case MODE_GETNEXT:
            DEBUGMSGTL(("docsIfUpstreamChannelTable_handler",
                        "GETNEXT\n"));
            /*
             * Check to see if var is in this subtree. If not, just
             * get the first object by using rootoid.1.firstColumn 
             */
            if ((netsnmp_oid_is_subtree
                 (reginfo->rootoid, reginfo->rootoid_len, var->name,
                  var->name_length) == 0)
                && (var->name_length >= reginfo->rootoid_len + 2)) {
                DEBUGMSGTL(("docsIfUpstreamChannelTable_handler",
                            "In Subtree - using var:\n"));
                tmpOidLen = var->name_length;
                memcpy((char *) tmpOid, (char *) var->name,
                       tmpOidLen * sizeof(oid));
                retVal =
                    v2GetNext(tmpOid, &tmpOidLen, reginfo->rootoid_len + 2,
                              tmpVal, &tmpValLen, reqinfo);
                if ((retVal == SNMP_ERR_NOSUCHNAME)
                    && (tmpOid[reginfo->rootoid_len + 1] < 10)) {
                    /*
                     * more columns to try 
                     */
                    tmpOidLen = reginfo->rootoid_len + 2;
                    tmpOid[tmpOidLen - 1] = tmpOid[tmpOidLen - 1] + 1;
                    retVal = v2GetNext(tmpOid, &tmpOidLen, tmpOidLen,
                                       tmpVal, &tmpValLen, reqinfo);
                }
            } else {            /* not in subtree */
                tmpOidLen = reginfo->rootoid_len;
                memcpy((char *) tmpOid, (char *) reginfo->rootoid,
                       tmpOidLen * sizeof(oid));
                tmpOid[tmpOidLen] = 1;
                tmpOidLen++;
                tmpOid[tmpOidLen] = 1;
                tmpOidLen++;
                retVal = v2GetNext(tmpOid, &tmpOidLen, tmpOidLen,
                                   tmpVal, &tmpValLen, reqinfo);
            }

            if (retVal == SNMP_ERR_NOERROR) {
                snmp_set_var_objid(var, tmpOid, tmpOidLen);
                switch (var->name[reginfo->rootoid_len + 1]) {
                case COLUMN_DOCSIFUPCHANNELID:
                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                             (u_char *) tmpVal, tmpValLen);
                    break;

                case COLUMN_DOCSIFUPCHANNELFREQUENCY:
                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                             (u_char *) tmpVal, tmpValLen);
                    break;

                case COLUMN_DOCSIFUPCHANNELWIDTH:
                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                             (u_char *) tmpVal, tmpValLen);
                    break;

                case COLUMN_DOCSIFUPCHANNELMODULATIONPROFILE:
                    snmp_set_var_typed_value(var, ASN_UNSIGNED,
                                             (u_char *) tmpVal, tmpValLen);
                    break;

                case COLUMN_DOCSIFUPCHANNELSLOTSIZE:
                    snmp_set_var_typed_value(var, ASN_UNSIGNED,
                                             (u_char *) tmpVal, tmpValLen);
                    break;

                case COLUMN_DOCSIFUPCHANNELTXTIMINGOFFSET:
                    snmp_set_var_typed_value(var, ASN_UNSIGNED,
                                             (u_char *) tmpVal, tmpValLen);
                    break;

                case COLUMN_DOCSIFUPCHANNELRANGINGBACKOFFSTART:
                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                             (u_char *) tmpVal, tmpValLen);
                    break;

                case COLUMN_DOCSIFUPCHANNELRANGINGBACKOFFEND:
                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                             (u_char *) tmpVal, tmpValLen);
                    break;

                case COLUMN_DOCSIFUPCHANNELTXBACKOFFSTART:
                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                             (u_char *) tmpVal, tmpValLen);
                    break;

                case COLUMN_DOCSIFUPCHANNELTXBACKOFFEND:
                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                             (u_char *) tmpVal, tmpValLen);
                    break;


                default:
                    /*
                     * We shouldn't get here
                     */
                    snmp_log(LOG_ERR,
                             "problem encountered in docsIfUpstreamChannelTable_handler: unknown column\n");

                }               /* switch on column */
            } else if (retVal == SNMP_ERR_NOSUCHNAME) {
                /*
                 * if V2 returns NOSUCH, netsnmp wants this handler
                 * to return NOERR, but we don't netsnmp_set_request_error
                 * or snmp_set_var_*. Tricky, tricky! 
                 */
                retVal = SNMP_ERR_NOERROR;
            } else {            /* retVal has a real error code */
                netsnmp_set_request_error(reqinfo, requests, retVal);
            }
            break;

        case MODE_SET_RESERVE1:
            printf
                ("docsIfUpstreamChannelTable_handler: Mode = MODE_SET_RESERVE\n");
            switch (var->name[reginfo->rootoid_len + 1]) {
            case COLUMN_DOCSIFUPCHANNELFREQUENCY:
                if (requests->requestvb->type != ASN_INTEGER) {
                    netsnmp_set_request_error(reqinfo, requests,
                                              SNMP_ERR_WRONGTYPE);
                    retVal = SNMP_ERR_WRONGTYPE;
                } else {
                    retVal = v2Test(requests->requestvb->name,
                                    requests->requestvb->name_length,
                                    requests->requestvb->val.string,
                                    requests->requestvb->val_len,
                                    requests->requestvb->type, reqinfo);
                    if (retVal != SNMP_ERR_NOERROR)
                        netsnmp_set_request_error(reqinfo, requests,
                                                  retVal);
                }
                break;
            case COLUMN_DOCSIFUPCHANNELWIDTH:
                if (requests->requestvb->type != ASN_INTEGER) {
                    netsnmp_set_request_error(reqinfo, requests,
                                              SNMP_ERR_WRONGTYPE);
                    retVal = SNMP_ERR_WRONGTYPE;
                } else {
                    retVal = v2Test(requests->requestvb->name,
                                    requests->requestvb->name_length,
                                    requests->requestvb->val.string,
                                    requests->requestvb->val_len,
                                    requests->requestvb->type, reqinfo);
                    if (retVal != SNMP_ERR_NOERROR)
                        netsnmp_set_request_error(reqinfo, requests,
                                                  retVal);
                }
                break;
            case COLUMN_DOCSIFUPCHANNELMODULATIONPROFILE:
                if (requests->requestvb->type != ASN_UNSIGNED) {
                    netsnmp_set_request_error(reqinfo, requests,
                                              SNMP_ERR_WRONGTYPE);
                    retVal = SNMP_ERR_WRONGTYPE;
                } else {
                    retVal = v2Test(requests->requestvb->name,
                                    requests->requestvb->name_length,
                                    requests->requestvb->val.string,
                                    requests->requestvb->val_len,
                                    requests->requestvb->type, reqinfo);
                    if (retVal != SNMP_ERR_NOERROR)
                        netsnmp_set_request_error(reqinfo, requests,
                                                  retVal);
                }
                break;
            case COLUMN_DOCSIFUPCHANNELSLOTSIZE:
                if (requests->requestvb->type != ASN_UNSIGNED) {
                    netsnmp_set_request_error(reqinfo, requests,
                                              SNMP_ERR_WRONGTYPE);
                    retVal = SNMP_ERR_WRONGTYPE;
                } else {
                    retVal = v2Test(requests->requestvb->name,
                                    requests->requestvb->name_length,
                                    requests->requestvb->val.string,
                                    requests->requestvb->val_len,
                                    requests->requestvb->type, reqinfo);
                    if (retVal != SNMP_ERR_NOERROR)
                        netsnmp_set_request_error(reqinfo, requests,
                                                  retVal);
                }
                break;
            case COLUMN_DOCSIFUPCHANNELRANGINGBACKOFFSTART:
                if (requests->requestvb->type != ASN_INTEGER) {
                    netsnmp_set_request_error(reqinfo, requests,
                                              SNMP_ERR_WRONGTYPE);
                    retVal = SNMP_ERR_WRONGTYPE;
                } else {
                    retVal = v2Test(requests->requestvb->name,
                                    requests->requestvb->name_length,
                                    requests->requestvb->val.string,
                                    requests->requestvb->val_len,
                                    requests->requestvb->type, reqinfo);
                    if (retVal != SNMP_ERR_NOERROR)
                        netsnmp_set_request_error(reqinfo, requests,
                                                  retVal);
                }
                break;
            case COLUMN_DOCSIFUPCHANNELRANGINGBACKOFFEND:
                if (requests->requestvb->type != ASN_INTEGER) {
                    netsnmp_set_request_error(reqinfo, requests,
                                              SNMP_ERR_WRONGTYPE);
                    retVal = SNMP_ERR_WRONGTYPE;
                } else {
                    retVal = v2Test(requests->requestvb->name,
                                    requests->requestvb->name_length,
                                    requests->requestvb->val.string,
                                    requests->requestvb->val_len,
                                    requests->requestvb->type, reqinfo);
                    if (retVal != SNMP_ERR_NOERROR)
                        netsnmp_set_request_error(reqinfo, requests,
                                                  retVal);
                }
                break;
            case COLUMN_DOCSIFUPCHANNELTXBACKOFFSTART:
                if (requests->requestvb->type != ASN_INTEGER) {
                    netsnmp_set_request_error(reqinfo, requests,
                                              SNMP_ERR_WRONGTYPE);
                    retVal = SNMP_ERR_WRONGTYPE;
                } else {
                    retVal = v2Test(requests->requestvb->name,
                                    requests->requestvb->name_length,
                                    requests->requestvb->val.string,
                                    requests->requestvb->val_len,
                                    requests->requestvb->type, reqinfo);
                    if (retVal != SNMP_ERR_NOERROR)
                        netsnmp_set_request_error(reqinfo, requests,
                                                  retVal);
                }
                break;
            case COLUMN_DOCSIFUPCHANNELTXBACKOFFEND:
                if (requests->requestvb->type != ASN_INTEGER) {
                    netsnmp_set_request_error(reqinfo, requests,
                                              SNMP_ERR_WRONGTYPE);
                    retVal = SNMP_ERR_WRONGTYPE;
                } else {
                    retVal = v2Test(requests->requestvb->name,
                                    requests->requestvb->name_length,
                                    requests->requestvb->val.string,
                                    requests->requestvb->val_len,
                                    requests->requestvb->type, reqinfo);
                    if (retVal != SNMP_ERR_NOERROR)
                        netsnmp_set_request_error(reqinfo, requests,
                                                  retVal);
                }
                break;
            default:
                /*
                 * We shouldn't get here 
                 */
                snmp_log(LOG_ERR,
                         "problem encountered in docsIfUpstreamChannelTable_handler: unknown column\n");
            }
            break;

        case MODE_SET_RESERVE2:
        case MODE_SET_ACTION:
        case MODE_SET_UNDO:
        case MODE_SET_FREE:
            break;
        case MODE_SET_COMMIT:
            printf
                ("docsIfUpstreamChannelTable_handler: Mode = MODE_SET_COMMIT\n");
            /*
             * really do the set! 
             */
            switch (var->name[reginfo->rootoid_len + 1]) {
            case COLUMN_DOCSIFUPCHANNELFREQUENCY:

                retVal = v2Set(requests->requestvb->name,
                               requests->requestvb->name_length,
                               requests->requestvb->val.string,
                               requests->requestvb->val_len,
                               requests->requestvb->type, reqinfo);
                if (retVal != SNMP_ERR_NOERROR)
                    netsnmp_set_request_error(reqinfo, requests, retVal);
                break;
            case COLUMN_DOCSIFUPCHANNELWIDTH:

                retVal = v2Set(requests->requestvb->name,
                               requests->requestvb->name_length,
                               requests->requestvb->val.string,
                               requests->requestvb->val_len,
                               requests->requestvb->type, reqinfo);
                if (retVal != SNMP_ERR_NOERROR)
                    netsnmp_set_request_error(reqinfo, requests, retVal);
                break;
            case COLUMN_DOCSIFUPCHANNELMODULATIONPROFILE:

                retVal = v2Set(requests->requestvb->name,
                               requests->requestvb->name_length,
                               requests->requestvb->val.string,
                               requests->requestvb->val_len,
                               requests->requestvb->type, reqinfo);
                if (retVal != SNMP_ERR_NOERROR)
                    netsnmp_set_request_error(reqinfo, requests, retVal);
                break;
            case COLUMN_DOCSIFUPCHANNELSLOTSIZE:

                retVal = v2Set(requests->requestvb->name,
                               requests->requestvb->name_length,
                               requests->requestvb->val.string,
                               requests->requestvb->val_len,
                               requests->requestvb->type, reqinfo);
                if (retVal != SNMP_ERR_NOERROR)
                    netsnmp_set_request_error(reqinfo, requests, retVal);
                break;
            case COLUMN_DOCSIFUPCHANNELRANGINGBACKOFFSTART:

                retVal = v2Set(requests->requestvb->name,
                               requests->requestvb->name_length,
                               requests->requestvb->val.string,
                               requests->requestvb->val_len,
                               requests->requestvb->type, reqinfo);
                if (retVal != SNMP_ERR_NOERROR)
                    netsnmp_set_request_error(reqinfo, requests, retVal);
                break;
            case COLUMN_DOCSIFUPCHANNELRANGINGBACKOFFEND:

                retVal = v2Set(requests->requestvb->name,
                               requests->requestvb->name_length,
                               requests->requestvb->val.string,
                               requests->requestvb->val_len,
                               requests->requestvb->type, reqinfo);
                if (retVal != SNMP_ERR_NOERROR)
                    netsnmp_set_request_error(reqinfo, requests, retVal);
                break;
            case COLUMN_DOCSIFUPCHANNELTXBACKOFFSTART:

                retVal = v2Set(requests->requestvb->name,
                               requests->requestvb->name_length,
                               requests->requestvb->val.string,
                               requests->requestvb->val_len,
                               requests->requestvb->type, reqinfo);
                if (retVal != SNMP_ERR_NOERROR)
                    netsnmp_set_request_error(reqinfo, requests, retVal);
                break;
            case COLUMN_DOCSIFUPCHANNELTXBACKOFFEND:

                retVal = v2Set(requests->requestvb->name,
                               requests->requestvb->name_length,
                               requests->requestvb->val.string,
                               requests->requestvb->val_len,
                               requests->requestvb->type, reqinfo);
                if (retVal != SNMP_ERR_NOERROR)
                    netsnmp_set_request_error(reqinfo, requests, retVal);
                break;
            default:
                /*
                 * We shouldn't get here 
                 */
                snmp_log(LOG_ERR,
                         "problem encountered in docsIfUpstreamChannelTable_handler: unknown column\n");
            }

            break;


        default:
            snmp_log(LOG_ERR,
                     "problem encountered in _handler: unsupported mode\n");
        }
    }
    return retVal;
}
