/*
 * Note: this file originally auto-generated by mib2c using
 *        mib2c.brcm.iterate.conf 2003/6/16 turcotte 
 */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>
#include "docsIfQosProfileTable.h"

/** Initialize the docsIfQosProfileTable table by defining its contents and how it's structured */
void
initialize_table_docsIfQosProfileTable(void)
{
    static oid      docsIfQosProfileTable_oid[] =
        { 1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 3 };
    netsnmp_handler_registration *my_handler;

    /*
     * create the table structure itself 
     */

    /*
     * if your table is read only, it's easiest to change the
     * HANDLER_CAN_RWRITE definition below to HANDLER_CAN_RONLY 
     */
    my_handler =
        netsnmp_create_handler_registration("docsIfQosProfileTable",
                                            docsIfQosProfileTable_handler,
                                            docsIfQosProfileTable_oid,
                                            OID_LENGTH
                                            (docsIfQosProfileTable_oid),
                                            HANDLER_CAN_RWRITE);

    if (my_handler) {
        if (netsnmp_register_handler(my_handler)) {
            DEBUGMSGTL(("initialize_table_docsIfQosProfileTable",
                        "Handler registration failed!\n"));
            return;
        }
    } else {
        DEBUGMSGTL(("initialize_table_docsIfQosProfileTable",
                    "Handler create failed!\n"));
        return;
    }
    DEBUGMSGTL(("initialize_table_docsIfQosProfileTable",
                "Handler created and registered.\n"));



}

/** Initializes the docsIfQosProfileTable module */
void
init_docsIfQosProfileTable(void)
{

    /*
     * here we initialize all the tables we're planning on supporting 
     */
    initialize_table_docsIfQosProfileTable();
}

/** handles requests for the docsIfQosProfileTable table */
int
docsIfQosProfileTable_handler(netsnmp_mib_handler *handler,
                              netsnmp_handler_registration *reginfo,
                              netsnmp_agent_request_info *reqinfo,
                              netsnmp_request_info *requests)
{

    netsnmp_request_info *request;
    netsnmp_variable_list *var;
    char           *tmpVal[MAX_OID_LEN * sizeof(oid)];
    size_t          tmpValLen;
    int             tmpAsnType, tmpOidLen;
    oid             tmpOid[MAX_OID_LEN];
    int             retVal = SNMP_ERR_NOERROR;

    for (request = requests; request; request = request->next) {
        var = request->requestvb;
        if (request->processed != 0)
            continue;

        /*
         * perform anything here that you need to do before each
         * request is processed. 
         */

        switch (reqinfo->mode) {
        case MODE_GET:
            retVal = v2Get(var->name, var->name_length, tmpVal,
                           &tmpValLen, reqinfo);
            if (retVal == SNMP_ERR_NOERROR) {
                switch (var->name[reginfo->rootoid_len + 1]) {
                case COLUMN_DOCSIFQOSPROFPRIORITY:
                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                             (u_char *) tmpVal, tmpValLen);
                    break;

                case COLUMN_DOCSIFQOSPROFMAXUPBANDWIDTH:
                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                             (u_char *) tmpVal, tmpValLen);
                    break;

                case COLUMN_DOCSIFQOSPROFGUARUPBANDWIDTH:
                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                             (u_char *) tmpVal, tmpValLen);
                    break;

                case COLUMN_DOCSIFQOSPROFMAXDOWNBANDWIDTH:
                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                             (u_char *) tmpVal, tmpValLen);
                    break;

                case COLUMN_DOCSIFQOSPROFMAXTXBURST:
                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                             (u_char *) tmpVal, tmpValLen);
                    break;

                case COLUMN_DOCSIFQOSPROFBASELINEPRIVACY:
                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                             (u_char *) tmpVal, tmpValLen);
                    break;

                case COLUMN_DOCSIFQOSPROFSTATUS:
                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                             (u_char *) tmpVal, tmpValLen);
                    break;

                default:
                    /*
                     * We shouldn't get here 
                     */
                    snmp_log(LOG_ERR,
                             "problem encountered in docsIfQosProfileTable_handler: unknown column\n");
                }
            } else {
                netsnmp_set_request_error(reqinfo, requests, retVal);
            }
            break;
        case MODE_GETNEXT:
            DEBUGMSGTL(("docsIfQosProfileTable_handler", "GETNEXT\n"));
            /*
             * Check to see if var is in this subtree. If not, just
             * get the first object by using rootoid.1.firstColumn 
             */
            if ((netsnmp_oid_is_subtree
                 (reginfo->rootoid, reginfo->rootoid_len, var->name,
                  var->name_length) == 0)
                && (var->name_length >= reginfo->rootoid_len + 2)) {
                DEBUGMSGTL(("docsIfQosProfileTable_handler",
                            "In Subtree - using var:\n"));
                tmpOidLen = var->name_length;
                memcpy((char *) tmpOid, (char *) var->name,
                       tmpOidLen * sizeof(oid));
                retVal =
                    v2GetNext(tmpOid, &tmpOidLen, reginfo->rootoid_len + 2,
                              tmpVal, &tmpValLen, reqinfo);
                if ((retVal == SNMP_ERR_NOSUCHNAME)
                    && (tmpOid[reginfo->rootoid_len + 1] < 8)) {
                    /*
                     * more columns to try 
                     */
                    tmpOidLen = reginfo->rootoid_len + 2;
                    tmpOid[tmpOidLen - 1] = tmpOid[tmpOidLen - 1] + 1;
                    retVal = v2GetNext(tmpOid, &tmpOidLen, tmpOidLen,
                                       tmpVal, &tmpValLen, reqinfo);
                }
            } else {            /* not in subtree */
                tmpOidLen = reginfo->rootoid_len;
                memcpy((char *) tmpOid, (char *) reginfo->rootoid,
                       tmpOidLen * sizeof(oid));
                tmpOid[tmpOidLen] = 1;
                tmpOidLen++;
                tmpOid[tmpOidLen] = 2;
                tmpOidLen++;
                retVal = v2GetNext(tmpOid, &tmpOidLen, tmpOidLen,
                                   tmpVal, &tmpValLen, reqinfo);
            }

            if (retVal == SNMP_ERR_NOERROR) {
                snmp_set_var_objid(var, tmpOid, tmpOidLen);
                switch (var->name[reginfo->rootoid_len + 1]) {
                case COLUMN_DOCSIFQOSPROFPRIORITY:
                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                             (u_char *) tmpVal, tmpValLen);
                    break;

                case COLUMN_DOCSIFQOSPROFMAXUPBANDWIDTH:
                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                             (u_char *) tmpVal, tmpValLen);
                    break;

                case COLUMN_DOCSIFQOSPROFGUARUPBANDWIDTH:
                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                             (u_char *) tmpVal, tmpValLen);
                    break;

                case COLUMN_DOCSIFQOSPROFMAXDOWNBANDWIDTH:
                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                             (u_char *) tmpVal, tmpValLen);
                    break;

                case COLUMN_DOCSIFQOSPROFMAXTXBURST:
                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                             (u_char *) tmpVal, tmpValLen);
                    break;

                case COLUMN_DOCSIFQOSPROFBASELINEPRIVACY:
                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                             (u_char *) tmpVal, tmpValLen);
                    break;

                case COLUMN_DOCSIFQOSPROFSTATUS:
                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                             (u_char *) tmpVal, tmpValLen);
                    break;


                default:
                    /*
                     * We shouldn't get here
                     */
                    snmp_log(LOG_ERR,
                             "problem encountered in docsIfQosProfileTable_handler: unknown column\n");

                }               /* switch on column */
            } else if (retVal == SNMP_ERR_NOSUCHNAME) {
                /*
                 * if V2 returns NOSUCH, netsnmp wants this handler
                 * to return NOERR, but we don't netsnmp_set_request_error
                 * or snmp_set_var_*. Tricky, tricky! 
                 */
                retVal = SNMP_ERR_NOERROR;
            } else {            /* retVal has a real error code */
                netsnmp_set_request_error(reqinfo, requests, retVal);
            }
            break;

        case MODE_SET_RESERVE1:
            printf
                ("docsIfQosProfileTable_handler: Mode = MODE_SET_RESERVE\n");
            switch (var->name[reginfo->rootoid_len + 1]) {
            case COLUMN_DOCSIFQOSPROFPRIORITY:
                if (requests->requestvb->type != ASN_INTEGER) {
                    netsnmp_set_request_error(reqinfo, requests,
                                              SNMP_ERR_WRONGTYPE);
                    retVal = SNMP_ERR_WRONGTYPE;
                } else {
                    retVal = v2Test(requests->requestvb->name,
                                    requests->requestvb->name_length,
                                    requests->requestvb->val.string,
                                    requests->requestvb->val_len,
                                    requests->requestvb->type, reqinfo);
                    if (retVal != SNMP_ERR_NOERROR)
                        netsnmp_set_request_error(reqinfo, requests,
                                                  retVal);
                }
                break;
            case COLUMN_DOCSIFQOSPROFMAXUPBANDWIDTH:
                if (requests->requestvb->type != ASN_INTEGER) {
                    netsnmp_set_request_error(reqinfo, requests,
                                              SNMP_ERR_WRONGTYPE);
                    retVal = SNMP_ERR_WRONGTYPE;
                } else {
                    retVal = v2Test(requests->requestvb->name,
                                    requests->requestvb->name_length,
                                    requests->requestvb->val.string,
                                    requests->requestvb->val_len,
                                    requests->requestvb->type, reqinfo);
                    if (retVal != SNMP_ERR_NOERROR)
                        netsnmp_set_request_error(reqinfo, requests,
                                                  retVal);
                }
                break;
            case COLUMN_DOCSIFQOSPROFGUARUPBANDWIDTH:
                if (requests->requestvb->type != ASN_INTEGER) {
                    netsnmp_set_request_error(reqinfo, requests,
                                              SNMP_ERR_WRONGTYPE);
                    retVal = SNMP_ERR_WRONGTYPE;
                } else {
                    retVal = v2Test(requests->requestvb->name,
                                    requests->requestvb->name_length,
                                    requests->requestvb->val.string,
                                    requests->requestvb->val_len,
                                    requests->requestvb->type, reqinfo);
                    if (retVal != SNMP_ERR_NOERROR)
                        netsnmp_set_request_error(reqinfo, requests,
                                                  retVal);
                }
                break;
            case COLUMN_DOCSIFQOSPROFMAXDOWNBANDWIDTH:
                if (requests->requestvb->type != ASN_INTEGER) {
                    netsnmp_set_request_error(reqinfo, requests,
                                              SNMP_ERR_WRONGTYPE);
                    retVal = SNMP_ERR_WRONGTYPE;
                } else {
                    retVal = v2Test(requests->requestvb->name,
                                    requests->requestvb->name_length,
                                    requests->requestvb->val.string,
                                    requests->requestvb->val_len,
                                    requests->requestvb->type, reqinfo);
                    if (retVal != SNMP_ERR_NOERROR)
                        netsnmp_set_request_error(reqinfo, requests,
                                                  retVal);
                }
                break;
            case COLUMN_DOCSIFQOSPROFMAXTXBURST:
                if (requests->requestvb->type != ASN_INTEGER) {
                    netsnmp_set_request_error(reqinfo, requests,
                                              SNMP_ERR_WRONGTYPE);
                    retVal = SNMP_ERR_WRONGTYPE;
                } else {
                    retVal = v2Test(requests->requestvb->name,
                                    requests->requestvb->name_length,
                                    requests->requestvb->val.string,
                                    requests->requestvb->val_len,
                                    requests->requestvb->type, reqinfo);
                    if (retVal != SNMP_ERR_NOERROR)
                        netsnmp_set_request_error(reqinfo, requests,
                                                  retVal);
                }
                break;
            case COLUMN_DOCSIFQOSPROFBASELINEPRIVACY:
                if (requests->requestvb->type != ASN_INTEGER) {
                    netsnmp_set_request_error(reqinfo, requests,
                                              SNMP_ERR_WRONGTYPE);
                    retVal = SNMP_ERR_WRONGTYPE;
                } else {
                    retVal = v2Test(requests->requestvb->name,
                                    requests->requestvb->name_length,
                                    requests->requestvb->val.string,
                                    requests->requestvb->val_len,
                                    requests->requestvb->type, reqinfo);
                    if (retVal != SNMP_ERR_NOERROR)
                        netsnmp_set_request_error(reqinfo, requests,
                                                  retVal);
                }
                break;
            case COLUMN_DOCSIFQOSPROFSTATUS:
                if (requests->requestvb->type != ASN_INTEGER) {
                    netsnmp_set_request_error(reqinfo, requests,
                                              SNMP_ERR_WRONGTYPE);
                    retVal = SNMP_ERR_WRONGTYPE;
                } else {
                    retVal = v2Test(requests->requestvb->name,
                                    requests->requestvb->name_length,
                                    requests->requestvb->val.string,
                                    requests->requestvb->val_len,
                                    requests->requestvb->type, reqinfo);
                    if (retVal != SNMP_ERR_NOERROR)
                        netsnmp_set_request_error(reqinfo, requests,
                                                  retVal);
                }
                break;
            default:
                /*
                 * We shouldn't get here 
                 */
                snmp_log(LOG_ERR,
                         "problem encountered in docsIfQosProfileTable_handler: unknown column\n");
            }
            break;

        case MODE_SET_RESERVE2:
        case MODE_SET_ACTION:
        case MODE_SET_UNDO:
        case MODE_SET_FREE:
            break;
        case MODE_SET_COMMIT:
            printf
                ("docsIfQosProfileTable_handler: Mode = MODE_SET_COMMIT\n");
            /*
             * really do the set! 
             */
            switch (var->name[reginfo->rootoid_len + 1]) {
            case COLUMN_DOCSIFQOSPROFPRIORITY:

                retVal = v2Set(requests->requestvb->name,
                               requests->requestvb->name_length,
                               requests->requestvb->val.string,
                               requests->requestvb->val_len,
                               requests->requestvb->type, reqinfo);
                if (retVal != SNMP_ERR_NOERROR)
                    netsnmp_set_request_error(reqinfo, requests, retVal);
                break;
            case COLUMN_DOCSIFQOSPROFMAXUPBANDWIDTH:

                retVal = v2Set(requests->requestvb->name,
                               requests->requestvb->name_length,
                               requests->requestvb->val.string,
                               requests->requestvb->val_len,
                               requests->requestvb->type, reqinfo);
                if (retVal != SNMP_ERR_NOERROR)
                    netsnmp_set_request_error(reqinfo, requests, retVal);
                break;
            case COLUMN_DOCSIFQOSPROFGUARUPBANDWIDTH:

                retVal = v2Set(requests->requestvb->name,
                               requests->requestvb->name_length,
                               requests->requestvb->val.string,
                               requests->requestvb->val_len,
                               requests->requestvb->type, reqinfo);
                if (retVal != SNMP_ERR_NOERROR)
                    netsnmp_set_request_error(reqinfo, requests, retVal);
                break;
            case COLUMN_DOCSIFQOSPROFMAXDOWNBANDWIDTH:

                retVal = v2Set(requests->requestvb->name,
                               requests->requestvb->name_length,
                               requests->requestvb->val.string,
                               requests->requestvb->val_len,
                               requests->requestvb->type, reqinfo);
                if (retVal != SNMP_ERR_NOERROR)
                    netsnmp_set_request_error(reqinfo, requests, retVal);
                break;
            case COLUMN_DOCSIFQOSPROFMAXTXBURST:

                retVal = v2Set(requests->requestvb->name,
                               requests->requestvb->name_length,
                               requests->requestvb->val.string,
                               requests->requestvb->val_len,
                               requests->requestvb->type, reqinfo);
                if (retVal != SNMP_ERR_NOERROR)
                    netsnmp_set_request_error(reqinfo, requests, retVal);
                break;
            case COLUMN_DOCSIFQOSPROFBASELINEPRIVACY:

                retVal = v2Set(requests->requestvb->name,
                               requests->requestvb->name_length,
                               requests->requestvb->val.string,
                               requests->requestvb->val_len,
                               requests->requestvb->type, reqinfo);
                if (retVal != SNMP_ERR_NOERROR)
                    netsnmp_set_request_error(reqinfo, requests, retVal);
                break;
            case COLUMN_DOCSIFQOSPROFSTATUS:

                retVal = v2Set(requests->requestvb->name,
                               requests->requestvb->name_length,
                               requests->requestvb->val.string,
                               requests->requestvb->val_len,
                               requests->requestvb->type, reqinfo);
                if (retVal != SNMP_ERR_NOERROR)
                    netsnmp_set_request_error(reqinfo, requests, retVal);
                break;
            default:
                /*
                 * We shouldn't get here 
                 */
                snmp_log(LOG_ERR,
                         "problem encountered in docsIfQosProfileTable_handler: unknown column\n");
            }

            break;


        default:
            snmp_log(LOG_ERR,
                     "problem encountered in _handler: unsupported mode\n");
        }
    }
    return retVal;
}
