//****************************************************************************
//
// Broadcom Proprietary and Confidential. (c) 2012-2017 Broadcom.  All rights reserved.
// The term �Broadcom� refers to Broadcom Limited and/or its subsidiaries.
//
// This program is the proprietary software of Broadcom and/or
// its licensors, and may only be used, duplicated, modified or distributed
// pursuant to the terms and conditions of a separate, written license
// agreement executed between you and Broadcom (an "Authorized License").
// Except as set forth in an Authorized License, Broadcom grants no license
// (express or implied), right to use, or waiver of any kind with respect to
// the Software, and Broadcom expressly reserves all rights in and to the
// Software and all intellectual property rights therein. IF YOU HAVE NO
// AUTHORIZED LICENSE, THEN YOU HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY,
// AND SHOULD IMMEDIATELY NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE
// SOFTWARE.
//
// Except as expressly set forth in the Authorized License,
//
// 1. This program, including its structure, sequence and organization,
// constitutes the valuable trade secrets of Broadcom, and you shall use all
// reasonable efforts to protect the confidentiality thereof, and to use this
// information only in connection with your use of Broadcom integrated circuit
// products.
//
// 2. TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED
// "AS IS" AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS
// OR WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH
// RESPECT TO THE SOFTWARE. BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL
// IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR
// A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET
// ENJOYMENT, QUIET POSSESSION OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME
// THE ENTIRE RISK ARISING OUT OF USE OR PERFORMANCE OF THE SOFTWARE.
//
// 3. TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM
// OR ITS LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL,
// INDIRECT, OR EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY
// RELATING TO YOUR USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM
// HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN
// EXCESS OF THE AMOUNT ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1,
// WHICHEVER IS GREATER. THESE LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY
// FAILURE OF ESSENTIAL PURPOSE OF ANY LIMITED REMEDY.
//
//****************************************************************************
//
//  Filename:       openssh_to_ecos.h
//  Author:         S. Wilder
//  Creation Date:  May 10, 2018
//
//****************************************************************************
//
//  Description:
//****************************************************************************

#ifndef OPENSSH_TO_ECOS_H
#define OPENSSH_TO_ECOS_H

#include "includes.h"
#include "zconf.h"
#include "zlib.h"
#include "termios.h"

// Defined in SshThread.cpp
extern const char *  GetRemoteAccessUserName(void);
extern const char *  GetRemoteAccessPassword(void);
extern void          SshThreadReceiveData(char * pData, unsigned int data_len);
extern void *        OpenSshLogMemoryAlloc (const char *pFileName, int lineNumber, void * pMemory, unsigned int size );
extern void          OpenSshLogMemoryFree  (unsigned char * pMemory );
extern void          DumpAllocatedMemory   (void);
extern void          eCos_kexecdhs_cleanup( void );
extern bool          GetCmMacAddress( unsigned char * macAddr1,unsigned char *macAddr2,unsigned char *macAddr3,unsigned char *macAddr4,unsigned char *macAddr5,unsigned char *macAddr6);
extern void          Sleep();
extern int             gettimeofday(struct timeval *tv, struct timezone *tz);
extern unsigned long SystemTimeMS(void);

//******************************************************************************/
//*******       isascii                *****************************************/
//******************************************************************************/

int isascii(int c);


//******************************************************************************/
//*******       Set Defaults     *****************************************/
//******************************************************************************/
void SetSSHKeyGenDefaults(void);

void SetSSHKeyGenDefaults(void);

//******************************************************************************/
//*******       fopen                  *****************************************/
//******************************************************************************/
FILE *Linux_fopen(const char *pathname, const char *mode);


//******************************************************************************/
//*******       chroot                 *****************************************/
//******************************************************************************/
int Linux_chroot(const char *path);


//******************************************************************************/
//*******       deflateEnd          ********************************************/
//******************************************************************************/
int Linux_deflateEnd (z_streamp strm);


//******************************************************************************/
//*******       inflateEnd         * *******************************************/
//******************************************************************************/
int Linux_inflateEnd (z_streamp strm);


//******************************************************************************/
//************     inflateInit_     ********************************************/
//******************************************************************************/
int Linux_inflateInit_ (z_streamp strm, const char *version, int stream_size);


//******************************************************************************/
//************     ideflateInit     ********************************************/
//******************************************************************************/
int Linux_deflateInit_(z_streamp strm, int level, const char *version, int stream_size);


//******************************************************************************/
//************     ideflate         ********************************************/
//******************************************************************************/
int  Linux_deflate (z_streamp strm, int flush );


//******************************************************************************/
//************     iinflate         ********************************************/
//******************************************************************************/
int  Linux_inflate (z_streamp strm, int flush );


//******************************************************************************/
//*******          setgroups        ********************************************/
//******************************************************************************/
int Linux_setgroups(int ngroups, const gid_t *grouplist );


//******************************************************************************/
//*******          setegid          ********************************************/
//******************************************************************************/
int Linux_setegid( uid_t egid );


//******************************************************************************/
//*******          seteuid          ********************************************/
//******************************************************************************/
int Linux_seteuid( uid_t euid );


//******************************************************************************/
//*******          unmask           ********************************************/
//******************************************************************************/
mode_t Linux_umask(mode_t mask);


//******************************************************************************/
//*******       initgroups         *********************************************/
//******************************************************************************/
int Linux_initgroups(const char *user, gid_t group);


//******************************************************************************/
//*******       endgrent         ***********************************************/
//******************************************************************************/
void Linux_endgrent(void);


//******************************************************************************/
//*******       gethostname         ********************************************/
//******************************************************************************/
int Linux_gethostname(char *name, size_t len);


//******************************************************************************/
//*******       execve           ***********************************************/
//******************************************************************************/
int Linux_execve( char *name, char **argv, char **envv);


//******************************************************************************/
//*******       temporarily_use_uid                               **************/
//******************************************************************************/
void Linux_temporarily_use_uid(struct passwd *pw);


//******************************************************************************/
//*******       getsid           ***********************************************/
//******************************************************************************/
pid_t Linux_getsid(pid_t pid);


//******************************************************************************/
//*******       getuid           ***********************************************/
//******************************************************************************/
uid_t Linux_getuid(void);


//******************************************************************************/
//*******       socketpair       ***********************************************/
//******************************************************************************/
int Linux_socketpair(int af, int type, int protocol, int sv[2]);


//******************************************************************************/
//*******       chmod       *    **********************************************/
//******************************************************************************/
int Linux_chmod(const char *pathname, mode_t mode);


//******************************************************************************/
//*******       fork            ***********************************************/
//******************************************************************************/
pid_t Linux_fork(void);


//******************************************************************************/
//*******       unlink           ***********************************************/
//******************************************************************************/
int Linux_unlink(const char *pathname);


//******************************************************************************/
//*******       popen           ***********************************************/
//******************************************************************************/
FILE * Linux_popen(const char *command, const char *type);



//******************************************************************************/
//*******       pclose          ***********************************************/
//******************************************************************************/
int Linux_pclose(FILE *stream);

//******************************************************************************/
//*******       close          ***********************************************/
//******************************************************************************/
int Linux_close(int fd);


//******************************************************************************/
//*******       open          ***********************************************/
//******************************************************************************/
int Linux_open(const char *pathname, int flags,...);


//******************************************************************************/
//*******       atomicio          ***********************************************/
//******************************************************************************/
size_t Linux_atomicio_read (ssize_t (*f) (int, void *, size_t), int fd, void *_s, size_t n);
size_t Linux_atomicio_write(ssize_t (*f) (int, void *, size_t), int fd, void *_s, size_t n);

//******************************************************************************/
//*******       openpty          ***********************************************/
//******************************************************************************/
int Linux_openpty(int *amaster, int *aslave, char *name, const struct termios *termp, const struct winsize *winp);

//**********************************************/
//*******          pty_setowner           ******/
//**********************************************/
void Linux_pty_setowner(struct passwd *pw, const char *tty);

//******************************************************************************/
//*******       pty_change_window_size               ***************************/
//******************************************************************************/
void Linux_pty_change_window_size(int ptyfd, u_int row, u_int col, u_int xpixel, u_int ypixel);


//******************************************************************************/
//*******      free                             ********************************/
//******************************************************************************/
void Linux_free(void * ptr);


//******************************************************************************/
//*******      realloc         *************************************************/
//******************************************************************************/
void * Linux_realloc(void *ptr, size_t new_size);


//******************************************************************************/
//*******      fcntl            ***********************************************/
//******************************************************************************/
int Linux_fcntl(int fd, int cmd, ... /* arg */ );


//******************************************************************************/
//*******      fchmod           ***********************************************/
//******************************************************************************/
int Linux_fchmod(int fd, mode_t mode);

//******************************************************************************/
//*******      pipe              ***********************************************/
//******************************************************************************/
int Linux_pipe(int pipefd[2]);

//******************************************************************************/
//*******      execlp            ***********************************************/
//******************************************************************************/
int Linux_execlp(const char *file, const char *arg, ...);

//******************************************************************************/
//*******      DumpHex            ***********************************************/
//******************************************************************************/
void DumpHex(const void* data, size_t size);

#endif
