//****************************************************************************
//
// Copyright (c) 2000-2014 Broadcom Corporation
//
// This program is the proprietary software of Broadcom Corporation and/or
// its licensors, and may only be used, duplicated, modified or distributed
// pursuant to the terms and conditions of a separate, written license
// agreement executed between you and Broadcom (an "Authorized License").
// Except as set forth in an Authorized License, Broadcom grants no license
// (express or implied), right to use, or waiver of any kind with respect to
// the Software, and Broadcom expressly reserves all rights in and to the
// Software and all intellectual property rights therein.  IF YOU HAVE NO
// AUTHORIZED LICENSE, THEN YOU HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY,
// AND SHOULD IMMEDIATELY NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE
// SOFTWARE.
//
// Except as expressly set forth in the Authorized License,
//
// 1.     This program, including its structure, sequence and organization,
// constitutes the valuable trade secrets of Broadcom, and you shall use all
// reasonable efforts to protect the confidentiality thereof, and to use this
// information only in connection with your use of Broadcom integrated circuit
// products.
//
// 2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED
// "AS IS" AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS
// OR WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH
// RESPECT TO THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL
// IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR
// A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET
// ENJOYMENT, QUIET POSSESSION OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME
// THE ENTIRE RISK ARISING OUT OF USE OR PERFORMANCE OF THE SOFTWARE.
//
// 3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM
// OR ITS LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL,
// INDIRECT, OR EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY
// RELATING TO YOUR USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM
// HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN
// EXCESS OF THE AMOUNT ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1,
// WHICHEVER IS GREATER. THESE LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY
// FAILURE OF ESSENTIAL PURPOSE OF ANY LIMITED REMEDY.
//
//****************************************************************************
//

#include "includes.h"
#include "log.h"
#include "key.h"
#include "zlib.h"
#include "zconf.h"
#include "signal.h"
#include "openssh_to_ecos.h"
#include <string.h>

#define DEBUG_PRINT

//OpenSSH Library related
extern  void           SetPointertoMemoryFunctions(void);
extern  void           (* ptrfree)(void *);
extern  void *         (* ptrrealloc)(void *, size_t);
extern  int            debug_flag;
extern  int            optreset;
extern  int            optind;
extern  int            connection_closed;
extern  int            eCos_cleanup_called;
extern  int            no_more_sessions;
char *  __progname        = "SetThisLaterForNow";
char *  SSHDProgName      = "SSHD_main";
char *  SSHKeyGenProgName = "SSHKeygen_main";
char *  BroadcomPty       = "Broadcom PTY";

// global variable used by the SSH eCos thread
int          gSshThreadPtyFd   = 0;
int          gSshThreadTtyFd   = 0;
unsigned int inactivityTimerMS;

//SSHKeyGen 
extern u_int32_t bits;

#if (OPENSSH_DEBUG)
   char * pCmdParamForMain[]                 = {"/SSHD_main","-D","-d","-d","-d","-e","-?",NULL};
   int    sizeofpCmdParamForMain             = 7;
   // For RSA Key
   char * pCmdParamForSSHKeygenRsa[]         = {"/SSHKeygen_main","-v","-v","-v","-f", "/etc/ssh/ssh_host_rsa_key_device","-t", "rsa","-b","2048", NULL};
   int    sizeofpCmdParamForSSHKeygenRsa     = 10;
   //For ECDSA Key
    char * pCmdParamForSSHKeygenECDSA[]      = {"/SSHKeygen_main","-v","-v","-v","-f", "/etc/ssh/ssh_host_ecdsa_key_device","-t", "ecdsa","-b","256", NULL};
    int    sizeofpCmdParamForSSHKeygenECDSA  = 10;
   // For  Key
   char * pCmdParamForSSHKeygenED25519[]     = {"/SSHKeygen_main","-v","-v","-v","-f", "/etc/ssh/ssh_host_ed25519_key_device","-t", "ed25519", "-b","256",NULL};
   int    sizeofpCmdParamForSSHKeygenED25519 = 10;
#else
   char * pCmdParamForMain[]                 = {"/SSHD_main","-D", NULL};
   int    sizeofpCmdParamForMain             = 2;
   // For RSA Key
   char * pCmdParamForSSHKeygenRsa[]         = {"/SSHKeygen_main","-f", "/etc/ssh/ssh_host_rsa_key_device","-t", "rsa","-b","2048", NULL};
   int    sizeofpCmdParamForSSHKeygenRsa     = 7;
   //For ECDSA Key
   char * pCmdParamForSSHKeygenECDSA[]       = {"/SSHKeygen_main","-f", "/etc/ssh/ssh_host_ecdsa_key_device","-t", "ecdsa", "-b","256",NULL};
   int    sizeofpCmdParamForSSHKeygenECDSA   = 7;
   // For ED25519 Key
   char * pCmdParamForSSHKeygenED25519[]     = {"/SSHKeygen_main","-f", "/etc/ssh/ssh_host_ed25519_key_device","-t", "ed25519", "-b","256",NULL};
   int    sizeofpCmdParamForSSHKeygenED25519 = 7;
#endif

#define DEBUG_PRINT(fmt, ...)

// The default host private keys we support
#include <keys/ssh_host_rsa_key.h>
#include <keys/ssh_host_ecdsa_key.h>
#include <keys/ssh_host_ed25519_key.h>
// The generated device specific private keys 
#include <keys/ssh_host_rsa_key_device.h>
#include <keys/ssh_host_ecdsa_key_device.h>
#include <keys/ssh_host_ed25519_key_device.h>
typedef struct 
{
    const char          * filename;
    unsigned int          size;
    unsigned int          position;
    const unsigned char * privateKey;
} key_file_mapping;

static key_file_mapping key_file_mapping_table[] = 
{
    {"/etc/ssh/ssh_host_rsa_key",           sizeof(ssh_host_rsa_key_private),           0,ssh_host_rsa_key_private  },
    {"/etc/ssh/ssh_host_ecdsa_key",         sizeof(ssh_host_ecdsa_key_private),         0,ssh_host_ecdsa_key_private},
    {"/etc/ssh/ssh_host_ed25519_key",       sizeof(ssh_host_ed25519_key_private),       0,ssh_host_ed25519_key_private},
    {"/etc/ssh/ssh_host_rsa_key_device",    sizeof(ssh_host_rsa_key_device_private),    0,ssh_host_rsa_key_device_private},
    {"/etc/ssh/ssh_host_ecdsa_key_device",  sizeof(ssh_host_ecdsa_key_device_private),  0,ssh_host_ecdsa_key_device_private},
    {"/etc/ssh/ssh_host_ed25519_key_device",sizeof(ssh_host_ed25519_key_devcie_private),0,ssh_host_ed25519_key_devcie_private},
    {NULL, 0,0, NULL}
};
static int sizeof_key_file_mapping_table = sizeof(key_file_mapping_table) / sizeof(key_file_mapping_table[0]); 

//From  ./gnutools/mipsisa32-elf/mipsisa32-elf/include/pwd.h
//struct passwd {
//        char   *pw_name;               /* user name */
//        char   *pw_passwd;             /* encrypted password */
//        int     pw_uid;                /* user uid */
//        int     pw_gid;                /* user gid */
//        char   *pw_comment;            /* comment */
//        char   *pw_gecos;              /* Honeywell login info */
//        char   *pw_dir;                /* home directory */
//        char   *pw_shell;              /* default shell */
//};
//
// User ID
#define OpenSSHDUid   1
#define SSHKeyGenUid  2
// Password data base 2 entries ... first for ssh and two for ssh-keygen
static struct passwd password_data_base[] =
{
   {"USERNAME901234567890123456789012",  "PASSWORD901234567890123456789012", OpenSSHDUid,  OpenSSHDUid,  "comment", "user information", "home dirctory", _PATH_BSHELL },
   {"Broadcom"         ,                 "broadcom",                         SSHKeyGenUid, SSHKeyGenUid, "comment", "user information", "home dirctory", _PATH_BSHELL }, // for ssh-keygen
   {NULL               ,                  NULL,                              555,          555,          NULL,      NULL,               NULL,            NULL         }
};


static void Dump_password_data_base(void)
{
   // Return pointer to first record containing the user
   struct passwd *pa = &password_data_base[0];

   while( pa->pw_name != NULL )
   {   
       DEBUG_PRINT("%#x user :%s",(unsigned int)pa->pw_name,pa->pw_name);       /* user name */
       DEBUG_PRINT("%#x passw:%s",(unsigned int)pa->pw_passwd,pa->pw_passwd);   /* encrypted password */
       DEBUG_PRINT("%#x uid  :%d",(unsigned int)pa->pw_uid,pa->pw_uid);         /* user uid */
       DEBUG_PRINT("%#x gid  :%d",(unsigned int)pa->pw_gid,pa->pw_gid);         /* user gid */
       DEBUG_PRINT("%#x commt:%s",(unsigned int)pa->pw_comment,pa->pw_comment); /* comment */
       DEBUG_PRINT("%#x login:%s",(unsigned int)pa->pw_gecos,pa->pw_gecos);     /* Honeywell login info */
       DEBUG_PRINT("%#x dirct:%s",(unsigned int)pa->pw_dir,pa->pw_dir);         /* home directory */
       DEBUG_PRINT("%#x shell:%s",(unsigned int)pa->pw_shell,pa->pw_shell);     /* default shell */
       DEBUG_PRINT();
       pa++;
   }
}


void SeteOpenSSHDDefaults(void)
{  
   SetPointertoMemoryFunctions();

   strcpy(__progname,SSHDProgName);

   Dump_password_data_base();

   //Return pointer to first record to store the user/password
   struct passwd *pa = &password_data_base[OpenSSHDUid-1];

   DEBUG_PRINT("username: %s",pa->pw_name);
   DEBUG_PRINT("password: %s",pa->pw_passwd);

   // Copy at most 32 characters
   if ( GetRemoteAccessUserName() != NULL ) 
       strncpy (pa->pw_name,GetRemoteAccessUserName(),32);

   if ( GetRemoteAccessPassword() != NULL )
       strncpy (pa->pw_passwd,GetRemoteAccessPassword(),32);
   else
   {   // Set to an empty string which is no passward
       // see sys_auth_passwd.
       pa->pw_passwd = "";
   }

   DEBUG_PRINT("username: %s",pa->pw_name);
   DEBUG_PRINT("password: %s",pa->pw_passwd);

   // Needed when calling getopt successively 
   optind = 1;

   // OpenSSH internal flags
   connection_closed = 0;
   no_more_sessions = 0;

   optreset = 1;
   debug_flag = 0;
   eCos_cleanup_called = 0;
}


void SetSSHKeyGenDefaults(void)
{   
   SetPointertoMemoryFunctions();

   strcpy(__progname,SSHKeyGenProgName);

   // Needed when calling getopt successively 
   optind    = 1;
   optreset  = 1;
   //Needs reset for new key generation 
   bits      =  0;
}


//**********************************************/
//*******       isascii                  ******/
//**********************************************/
int isascii(int c)
{
  // checks whether c is a  7-bit  unsigned  char  value that fits into the
  // ASCII character set.  This function is a BSD extension and is also an
  // SVID  extension.

  return ((c >= 0) && (c <= 127));
}


//***********************************************************************/
//*******       getpwnam                  *******************************/
// Taken from rbb_cm_lib/OpenSSH/ecos_pwd.c                             */
// Seems to only be used in ./Bfc/IpHelpers/SpectrumAnalyzer/mongoose.c */
// and OpenSSH linux calls                                              */
//***********************************************************************/
//struct passwd	* getpwnam (const char * user)
//{
//       // SD - taken from  auth.c fakepw()
//        static struct passwd fake;
//
//        memset(&fake, 0, sizeof(fake));
//        fake.pw_name = "NOUSER";
//        fake.pw_passwd =
//            "$2a$06$r3.juUaHZDlIbQaO2dS9FuYxL1W9M81R1Tc92PoSNmzvpEqLkLGrK";
//        fake.pw_gecos = "NOUSER";
//        fake.pw_uid = (uid_t)-1;
//        fake.pw_gid = (gid_t)-1;
//        fake.pw_dir = "/nonexist";
//        fake.pw_shell = "/nonexist";
//
//        return (&fake);
//}
//**********************************************/
//*******       getpwnam                  ******/
//**********************************************/
struct passwd * getpwnam (const char *name)
{  
   //Return pointer to first record containing the user
   struct passwd *pa = &password_data_base[0];

   while( pa->pw_name != NULL )
   {   
       
       DEBUG_PRINT("entered username: %s user: %s",name,pa->pw_name); 
       if( strcmp(name,pa->pw_name) == 0 )
       {
           return pa;
       }
       pa++;
   }

   // Not found 
   return NULL;
}

//**********************************************/
//*******       syslog                    ******/
//**********************************************/

void syslog (int __pri, const char *fmt, ...) 
{
    //if ( __pri <= trace_level )    //check for permission
    {
        va_list args;
      
        va_start( args, fmt );
        vfprintf( stdout, fmt, args );
        va_end( args );
      
        fflush( stdout );
    }
}

//void openlog (__const char *__ident, int __option, int __facility)
//DAEMON(3)                BSD Library Functions Manual                DAEMON(3)
//
//DESCRIPTION
//     The daemon() function is for programs wishing to detach themselves from
//     the controlling terminal and run in the background as system daemons.
//
//     Unless the argument nochdir is non-zero, daemon() changes the current
//     working directory to the root (/).
//
//     Unless the argument noclose is non-zero, daemon() will redirect standard
//     input, standard output, and standard error to /dev/null.
//
//RETURN VALUES
//     The daemon() function returns the value 0 if successful; otherwise the
//     value -1 is returned and the global variable errno is set to indicate the
//     error.
// 
// 
//**********************************************/
//*******          daemon               ******/
//**********************************************/
int Linux_daemon(int nochdir, int noclose)
{

   DEBUG_PRINT();

   return 0;

}

// this is a replacement for unix signals
void Linux_signal( int event, void (* handler_function)(int event)  )
{
    // sometimes, the signal handlers themselves send themselves the same signal. 
    // I don't understand why this would be, but we need to detect it to prevent
    // endless loop.  sighup_handler() is an example of this. 
    static void (*prev_handler_function)(int event) = NULL;
    
    if( handler_function != prev_handler_function )
    {
        prev_handler_function = handler_function;

        // invoke the handler function
        handler_function( event );
    }

    prev_handler_function = NULL;
}


int Linux_chdir(const char *path)
{
    return 0;
}

int Linux_socketpair(int af, int type, int protocol, int sv[2])
{   
     
    DEBUG_PRINT(); 

    if ( (sv[0] = socket(af, type, protocol)) == -1 )
    {
        error("Couldn't create socket 1: %s", strerror(errno));
        return -1;
    } 
    else if ( (sv[1] = socket(af, type, protocol)) == -1) 
    {
        error("Couldn't create socket 2: %s", strerror(errno));
        return -1;
    }

    return 0;
}

int Linux_stat(const char *pathname, struct stat *statbuf)
{
    DEBUG_PRINT("path:%s",pathname);

    return 0;
}

void Linux_fatal(const char *fmt, ...)
{
    char buf[1024];
    va_list args;

    va_start(args, fmt);
    vsnprintf(buf, sizeof(buf), fmt, args);
    va_end(args);

    DEBUG_PRINT("%s", buf);

}

//**********************************************/
//*******          getpwent               ******/
//**********************************************/
struct passwd * Linux_getpwent(void)
{
   DEBUG_PRINT(); 

   return NULL;

}

//**********************************************/
//*******          setpwent               ******/
//**********************************************/
void Linux_setpwent  (void)
{
    DEBUG_PRINT(); 
}

//**********************************************/
//*******          endpwent               ******/
//**********************************************/

void Linux_endpwent  (void)
{
    DEBUG_PRINT(); 
}

//**********************************************/
//*******          execv               ******/
//**********************************************/
int Linux_execv(char *path,char **argv)
{
    DEBUG_PRINT(); 

    return 0;
}

//**********************************************/
//*******          execxv               ******/
//**********************************************/
int Linux_execve( char *name, char **argv, char **envv)
{
    DEBUG_PRINT(); 

    return 0;
}

//**********************************************/
//*******          waitpid               ******/
//**********************************************/
pid_t Linux_waitpid(int pid, int *stat_loc, int options)
{
   pid_t wait_pid = 10;

   DEBUG_PRINT(); 

   return (wait_pid);
}

//**********************************************/
//*******          setgroups              ******/
//**********************************************/
int Linux_setgroups(int ngroups, const gid_t *grouplist )
{    
    DEBUG_PRINT(); 

    return 0;
}


//**********************************************/
//*******          setegid                ******/
//**********************************************/
int Linux_setegid( uid_t egid )
{    
    DEBUG_PRINT(); 

    return 0;
}


//**********************************************/
//*******          seteuid                ******/
//**********************************************/
int Linux_seteuid( uid_t euid )
{    
    DEBUG_PRINT(); 

    return 0;
}

//**********************************************/
//*******          closefrom              ******/
//**********************************************/
void Linux_closefrom(int lowfd)
{
    DEBUG_PRINT(); 
}


//**********************************************/
//*******          unmask              ******/
//**********************************************/
mode_t Linux_umask(mode_t mask)
{
   printf("Arg = %d %s\n",mask,__func__); 

   return mask;

}

//**********************************************/
//*******   openpty                       ******/
//**********************************************/

int Linux_openpty(int *amaster, int *aslave, char *name, const struct termios *termp, const struct winsize *winp)
{
   DEBUG_PRINT("Assigning pty: %d tty: %d",gSshThreadPtyFd,gSshThreadTtyFd); 

   //Assign our ecos sockets to OpenSSH pty and tty fd's
   *amaster = gSshThreadPtyFd;
   *aslave  = gSshThreadTtyFd;

   return 0;
 
}

int Linux_getpeereid(int s, uid_t *euid, gid_t *gid)
{
    DEBUG_PRINT(); 

   return 0;

}


//**********************************************/
//*******       temporarily_use_uid         ******/
//**********************************************/
/*
 * Temporarily changes to the given uid.  If the effective user
 * id is not root, this does nothing.  This call cannot be nested.
 */
void Linux_temporarily_use_uid(struct passwd *pw)
{
     DEBUG_PRINT(); 
}

//**********************************************/
//*******       restore_uid         ******/
//**********************************************/
void Linux_restore_uid(void)
{
    DEBUG_PRINT(); 

}

//**********************************************/
//*******       getpwuid                  ******/
//**********************************************/
struct passwd * Linux_getpwuid (uid_t uid)
{
   //Get user ID for currently running progrom of OpenSSHD or SSHKeyGen
   uid_t userId = Linux_getuid();

   //Return pointer to first record containing the user
   struct passwd *pa = &password_data_base[0];

   while( pa->pw_name != NULL )
   {   
       if( userId == pa->pw_uid) 
       {
           return pa;
       }
       pa++;
   }
   DEBUG_PRINT();

   // Not found 
   return NULL;
}
//**********************************************/
//*******       gethostname                  ******/
//**********************************************/
int Linux_gethostname(char *name, size_t len)
{

   char hostname[] = "eCos";

   if (len < sizeof(hostname)) 
   {
      return -1;
   }

   strcpy(name,hostname);

   DEBUG_PRINT(); 

   return 0;

}
//struct group *getgrent(void);
//
//void setgrent(void);
//
//void endgrent(void);


//**********************************************/
//*******       getgrent                  ******/
//**********************************************/
struct group * Linux_getgrent(void)
{
   DEBUG_PRINT(); 

   return NULL;
}
//**********************************************/
//*******       setgrent                  ******/
//**********************************************/
void Linux_setgrent(void)
{
    DEBUG_PRINT(); 
}

//**********************************************/
//*******       endgrent                  ******/
//**********************************************/
void Linux_endgrent(void)
{
    DEBUG_PRINT(); 
}


//**********************************************/
//*******       getgrgid                  ******/
//**********************************************/
struct group * Linux_getgrgid(gid_t gid)
{
   DEBUG_PRINT(); 

   return NULL;
}


//**********************************************/
//*******       setresuid                 ******/
//**********************************************/
int Linux_setresuid(uid_t ruid, uid_t euid, uid_t suid)
{
   DEBUG_PRINT(); 

   return 0;
}


//**********************************************/
//*******       setresgid                ******/
//**********************************************/
int Linux_setresgid(gid_t rgid, gid_t egid, gid_t sgid)
{
   DEBUG_PRINT(); 

   return 0;

}

//**********************************************/
//*******       chroot                ******/
//**********************************************/
int Linux_chroot(const char *path)
 {

    DEBUG_PRINT(); 

    return 0;

 }

//**********************************************/
//*******       initgroups                ******/
//**********************************************/
int Linux_initgroups(const char *user, gid_t group)
{
   DEBUG_PRINT(); 

   return 0;
}

//**********************************************/
//*******       execl                     ******/
//**********************************************/
int Linux_execl(const char *path, ... )
{
   DEBUG_PRINT(); 

   return 0;

}

//**********************************************/
//*******       realpath                  ******/
//**********************************************/
char * Linux_realpath(const char *path, char *resolved_path)
{
 
   DEBUG_PRINT(); 

   return NULL;

}


//**********************************************/
//*******       realpath                  ******/
//**********************************************/
char * Linux_dirname(const char *path)
{
 
   DEBUG_PRINT(); 

   return NULL;

}

//**********************************************/
//*******       getpagesize               ******/
//**********************************************/
int Linux_getpagesize(void)
{
   DEBUG_PRINT(); 

   return 0;
}


//**********************************************/
//*******       getsid                    ******/
//**********************************************/
pid_t Linux_getsid(pid_t pid)
{
 
   DEBUG_PRINT(); 

   return 0;

}



//**********************************************/
//*******       poll                      ******/
//**********************************************/
int Linux_poll(struct pollfd *fds, nfds_t nfds, int timeout)
{
   DEBUG_PRINT(); 

   return 0;

}


//**********************************************/
//*******       mkdtemp                   ******/
//**********************************************/
char * Linux_mkdtemp(char *path)
{

   DEBUG_PRINT(); 

   return NULL;

}


//**********************************************/
//*******       permanently_set_uid       ******/
//**********************************************/
void Linux_permanently_set_uid(struct passwd * pw)
{

    DEBUG_PRINT(); 


}

//**********************************************/
//*******       mkstemp                   ******/
//**********************************************/

int Linux_mkstemp(char *path)
{
   DEBUG_PRINT(); 

   return 0;

}

//**********************************************/
//*******       sftp_server_main          ******/
//**********************************************/
int Linux_sftp_server_main(int argc, char **argv, struct passwd *user_pw)
{   

   DEBUG_PRINT(); 

   return 0;
}


//**********************************************/
//*******     ssh_krl_file_contains_key    *****/
//**********************************************/
int Linux_ssh_krl_file_contains_key(const char *path, const struct sshkey *key)
{
   DEBUG_PRINT(); 

   return 0;
}


//**********************************************/
//*******       deflateEnd                ******/
//**********************************************/
int Linux_deflateEnd (z_streamp strm)
{

   DEBUG_PRINT(); 

   return 0;
}


//**********************************************/
//*******       inflateEnd                ******/
//**********************************************/
int Linux_inflateEnd (z_streamp strm)
{

   DEBUG_PRINT(); 

   return 0;
}


//**********************************************/
//*******       inflateInit_              ******/
//**********************************************/
int Linux_inflateInit_ (z_streamp strm, const char *version, int stream_size)
{

   DEBUG_PRINT(); 

   return 0;

}
//**********************************************/
//*******       deflateInit               ******/
//**********************************************/
int Linux_deflateInit_(z_streamp strm, int level, const char *version, int stream_size)
{

    DEBUG_PRINT(); 

   return 0;
}


//**********************************************/
//*******   deflate                       ******/
//**********************************************/
int  Linux_deflate (z_streamp strm, int flush )
{

    DEBUG_PRINT(); 

    return 0;
}


//**********************************************/
//*******   inflate                       ******/
//**********************************************/
int  Linux_inflate (z_streamp strm, int flush )
{

    DEBUG_PRINT(); 

    return 0;
}


//**********************************************/
//*******   getuid                        ******/
//**********************************************/
uid_t Linux_getuid(void)
{
   uid_t userId = 0; // Not valid for us but get's rid of a warning. 

   if( strcmp(__progname,SSHDProgName) == 0 )
       userId =  OpenSSHDUid;

   if( strcmp(__progname,SSHKeyGenProgName) == 0 )
       userId =  SSHKeyGenUid;

   DEBUG_PRINT("userId:%d",userId); 

   // Return a fake user ID 
   return userId;
}


//**********************************************/
//*******   fork                          ******/
//**********************************************/
pid_t Linux_fork(void)
{

    DEBUG_PRINT(); 

    return 0;
}


//**********************************************/
//*******   unlink                        ******/
//**********************************************/
int Linux_unlink(const char *pathname)
{

    DEBUG_PRINT(); 

    return 0;
}


//**********************************************/
//*******   popen                         ******/
//**********************************************/
FILE *Linux_popen(const char *command, const char *type)
{
    DEBUG_PRINT(); 

    return NULL;
}


//**********************************************/
//*******   popen                         ******/
//**********************************************/
int Linux_pclose(FILE *stream)
{
    DEBUG_PRINT(); 

    return -1;

}


//**********************************************/
//*******   close                        ******/
//**********************************************/
int Linux_close(int fd)
{
   
   // fd bigger than array ?   
   if (fd > sizeof_key_file_mapping_table)
   {
     
      DEBUG_PRINT("fd not found:%d",fd);
      return -1;
   }

   // close the file
   DEBUG_PRINT("closing fd:%d",fd);
   key_file_mapping_table[fd].position = 0;
   return 0;


}



//**********************************************/
//*******   open                          ******/
//**********************************************/
int Linux_open(const char *pathname, int flags, ...)
{       
        
        DEBUG_PRINT("file:%s",pathname);
        // Return the index to the array of private key files
        int fd = 0;
        while( key_file_mapping_table[fd].filename != NULL )
        {
            if( strcmp(pathname, key_file_mapping_table[fd].filename) == 0 )
            {   

                DEBUG_PRINT("file:%s fd:%d",pathname,fd);
                return fd;
            }
            fd++;
        }
        // Not found 
        return -1;

}

FILE *Linux_fopen(const char *pathname, const char *mode)
{

   DEBUG_PRINT();
   
   FILE * pFile = NULL;

   return pFile;    

}

//**********************************************/
//*******   atomicio                      ******/
//**********************************************/
size_t
Linux_atomicio_read(ssize_t (*f) (int, void *, size_t), int fd, void *_s, size_t n)
{      
    
   // We ignore the first argument since we are not doing file/socket IO.    
   // Copy over n bytes from fd array index to buffer *_s
   // Return bytes copied

  unsigned int bytesleft = key_file_mapping_table[fd].size - key_file_mapping_table[fd].position;
  unsigned int position = key_file_mapping_table[fd].position;

  DEBUG_PRINT("File     : %s",key_file_mapping_table[fd].filename);
  DEBUG_PRINT("Descrip  : %d",fd);
  DEBUG_PRINT("Size     : %d",key_file_mapping_table[fd].size);
  DEBUG_PRINT("Position : %d",key_file_mapping_table[fd].position);
  DEBUG_PRINT("bytes req: %d",n);
  DEBUG_PRINT("bytesleft: %d",bytesleft);

   // End of file?
   if (key_file_mapping_table[fd].position == key_file_mapping_table[fd].size ) 
   {
        return 0;
   } 
   // More bytes than left... return what's left
   else if (n > bytesleft ) 
   {
      n = bytesleft;
   }

   //Copy n bytes to _s from file
   memcpy( _s,key_file_mapping_table[fd].privateKey+position, n);

   //Save n bytes copyied
   key_file_mapping_table[fd].position += n;

//   DumpHex(key_file_mapping_table[fd].privateKey,key_file_mapping_table[fd].size);
   return n;

}


size_t
Linux_atomicio_write(ssize_t (*f) (int, void *, size_t), int fd, void *_s, size_t n)
{      
    
   // We ignore the first argument since we are not doing file/socket IO.    
   // write n bytes from * _s to the file fd
   // Return bytes written 

  unsigned int bytesleft = key_file_mapping_table[fd].size - key_file_mapping_table[fd].position;
  unsigned int position = key_file_mapping_table[fd].position;

  DEBUG_PRINT("File     : %s",key_file_mapping_table[fd].filename);
  DEBUG_PRINT("Descrip  : %d",fd);
  DEBUG_PRINT("Size     : %d",key_file_mapping_table[fd].size);
  DEBUG_PRINT("Position : %d",key_file_mapping_table[fd].position);
  DEBUG_PRINT("bytes req: %d",n);
  DEBUG_PRINT("bytesleft: %d",bytesleft);

   // End of file?
   if (key_file_mapping_table[fd].position == key_file_mapping_table[fd].size ) 
   {
        return 0;
   } 
   // More bytes than left... return what's left
   else if (n > bytesleft ) 
   {
      n = bytesleft;
   }

   //write n bytes from  _s to file
   memcpy((void* )key_file_mapping_table[fd].privateKey+position,_s, n);

   //Save n bytes copyied
   key_file_mapping_table[fd].position += n;
   key_file_mapping_table[fd].size      = n;

   DEBUG_PRINT("bytes copied: %d",n);
//   DumpHex(key_file_mapping_table[fd].privateKey,key_file_mapping_table[fd].size);

   return n;

}


//**********************************************/
//*******   sigaction                     ******/
//**********************************************/
int Linux_sigaction(int signum, const struct sigaction *act, struct sigaction *oldact)
{
   
     DEBUG_PRINT();

   return 0; // success
}



int Linux_chmod(const char *pathname, mode_t mode)
{

     DEBUG_PRINT();

   return 0; // success

}

int Linux_chown(const char *pathname, uid_t owner, gid_t group)
{

    DEBUG_PRINT();

    return 0; // success
 }


char * Linux_ttyname(int fd)
{  
   DEBUG_PRINT();

   char * name = BroadcomPty ;

   DEBUG_PRINT("name: %s\n",name);

   return name;
}

struct group *Linux_getgrnam(const char *name)
{

   DEBUG_PRINT();

   return NULL;

}

int Linux_dup(int oldfd)
{
    DEBUG_PRINT("duplicating %d",oldfd);
    return oldfd;
}


int Linux_fcntl(int fd, int cmd, ... /* arg */ )
{
   DEBUG_PRINT();

   return 0;

}


//******************************************/
//*******      free                   ******/
//******************************************/
void Linux_free(void *ptr)
{    
     
     if (ptr == NULL){
          fatal("NULL pointer given as argument");
          return;
     }

     DEBUG_MEMORY("freeing: %#x",(unsigned int)ptr);

     OpenSshLogMemoryFree( ptr );

     ptrfree(ptr);
}

void * Linux_realloc(void *ptr, size_t new_size)
{
    void *new_ptr;
    if (new_size == 0)
    {
        fatal("xrealloc: zero size");
    }

    if (ptr == NULL)
    {
        new_ptr = malloc(new_size);
    }
    else 
    {
      OpenSshLogMemoryFree( ptr );
      new_ptr = ptrrealloc(ptr, new_size);

      if (new_ptr == NULL)
      {
        fatal("xrealloc: out of memory (new_size %lu bytes)", (u_long) new_size);
      }
      DEBUG_MEMORY("Allocating memory:  %#x size: %d",(unsigned int)new_ptr, new_size); 
      OpenSshLogMemoryAlloc (__FILE__, __LINE__, new_ptr, new_size );
    }


    DEBUG_MEMORY("new_size:%d",new_size); 

    return new_ptr;
}

//**********************************************/
//*******   exit                          ******/
//**********************************************/
void ECOS_exit(x)
{
   DEBUG_PRINT("We shouldn't get here !!!!!:%d",x); 

}



//**********************************************/
//*******   gettimeofday                  ******/
// ignore tz we don't set the time             */
//**********************************************/
int Linux_gettimeofday(struct timeval *tv, struct timezone *tz)
{

   if (tv == NULL)
   {
       return -1;
   }
  
   tv->tv_sec  = tv->tv_sec = (SystemTimeMS() / 1000 );
   tv->tv_usec = 0L;

   DEBUG_PRINT("Seconds:%d",(int)tv->tv_sec);

   return 0;

}

//*********************************************/
//*******   pipe                         ******/
//*********************************************/
int Linux_pipe(int pipefd[2])
{
   DEBUG_PRINT();

   return 0;
}

//*********************************************/
//*******   fchmod                       ******/
//*********************************************/
int Linux_fchmod(int fd, mode_t mode)
{
    
   DEBUG_PRINT();

   return 0;

}
//*********************************************/
//*******   execlp                       ******/
//*Note: In Linux this function never returns */ 
//*********************************************/
int Linux_execlp(const char *file, const char *arg, ...)
{
   DEBUG_PRINT();

   return 0;
}
//**********************************************/
//*******   DumpHex                       ******/
//**********************************************/
void DumpHex(const void* data, size_t size) {
	char ascii[17];
	size_t i, j;
	ascii[16] = '\0';
	for (i = 0; i < size; ++i) {
		printf("%02X ", ((unsigned char*)data)[i]);
		if (((unsigned char*)data)[i] >= ' ' && ((unsigned char*)data)[i] <= '~') {
			ascii[i % 16] = ((unsigned char*)data)[i];
		} else {
			ascii[i % 16] = '.';
		}
		if ((i+1) % 8 == 0 || i+1 == size) {
			printf(" ");
			if ((i+1) % 16 == 0) {
				printf("|  %s \n", ascii);
			} else if (i+1 == size) {
				ascii[(i+1) % 16] = '\0';
				if ((i+1) % 16 <= 8) {
					printf(" ");
				}
				for (j = (i+1) % 16; j < 16; ++j) {
					printf("   ");
				}
				printf("|  %s \n", ascii);
			}
		}
	}
}


